/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.metircs;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Timer;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public abstract class ClientMetrics {
    private static MetricProxy metricProxy = new MetricProxy();

    public static void startMetrics() {
        ClientMetrics.startMetrics(true);
    }

    public static void startMetrics(boolean enableLog) {
        metricProxy.start(enableLog);
    }

    public static Meter getMeter(MetricType type) {
        return metricProxy.getMeter(type);
    }

    public static Timer getTimer(MetricType type) {
        return metricProxy.getTimer(type);
    }

    public static enum MetricType {
        PUT_QPS,
        PUT_RPS,
        PUT_TPS,
        PUT_LATENCY,
        GET_QPS,
        GET_RPS,
        GET_TPS,
        GET_LATENCY;

    }

    private static class MetricProxy {
        private MetricRegistry metricRegistry;
        private Slf4jReporter slf4jReporter;

        private MetricProxy() {
        }

        public synchronized void start(boolean enableLog) {
            this.metricRegistry = new MetricRegistry();
            if (enableLog) {
                this.slf4jReporter = Slf4jReporter.forRegistry(this.metricRegistry).outputTo(LoggerFactory.getLogger((String)"com.aliyun.datahub.client.metrics")).prefixedWith("Metric").convertDurationsTo(TimeUnit.MICROSECONDS).convertRatesTo(TimeUnit.SECONDS).withLoggingLevel(Slf4jReporter.LoggingLevel.INFO).build();
                this.slf4jReporter.start(1L, TimeUnit.MINUTES);
            }
        }

        public void stop() {
            if (this.slf4jReporter != null) {
                this.slf4jReporter.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Meter getMeter(MetricType type) {
            if (this.metricRegistry == null) {
                return null;
            }
            String metricName = MetricRegistry.name(ClientMetrics.class, type.name(), "meter");
            Meter meter = this.findMeter(metricName);
            if (meter != null) return meter;
            Class<ClientMetrics> clazz = ClientMetrics.class;
            synchronized (ClientMetrics.class) {
                meter = this.findMeter(metricName);
                if (meter != null) return meter;
                return this.metricRegistry.meter(metricName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Timer getTimer(MetricType type) {
            if (this.metricRegistry == null) {
                return null;
            }
            String metricName = MetricRegistry.name(ClientMetrics.class, type.name(), "timer");
            Timer timer = this.findTimer(metricName);
            if (timer != null) return timer;
            Class<ClientMetrics> clazz = ClientMetrics.class;
            synchronized (ClientMetrics.class) {
                timer = this.findTimer(metricName);
                if (timer != null) return timer;
                return this.metricRegistry.timer(metricName);
            }
        }

        private Timer findTimer(String timerName) {
            SortedMap<String, Timer> timerMap = this.metricRegistry.getTimers();
            return timerMap == null ? null : (Timer)timerMap.get(timerName);
        }

        private Meter findMeter(String meterName) {
            SortedMap<String, Meter> meterMap = this.metricRegistry.getMeters();
            return meterMap == null ? null : (Meter)meterMap.get(meterName);
        }
    }
}

