/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example;

import com.aliyun.datahub.client.example.BaseExample;
import com.aliyun.datahub.client.model.BlobRecordData;
import com.aliyun.datahub.client.model.CursorType;
import com.aliyun.datahub.client.model.Field;
import com.aliyun.datahub.client.model.FieldType;
import com.aliyun.datahub.client.model.GetCursorResult;
import com.aliyun.datahub.client.model.GetRecordsResult;
import com.aliyun.datahub.client.model.PutRecordsResult;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.TupleRecordData;
import java.util.ArrayList;

public class PutGetRecordsExample
extends BaseExample {
    @Override
    public void runExample() {
        this.putRecordsIntoTopic("0");
        this.getRecordsFromTopic("0");
        this.putRecordsByShardIntoTopic("1");
        this.getRecordsFromTopic("1");
    }

    private void putRecordsIntoTopic(String shardId) {
        ArrayList<RecordEntry> recordEntries = new ArrayList<RecordEntry>();
        for (int cnt = 0; cnt < 10; ++cnt) {
            RecordEntry entry = new RecordEntry();
            entry.setShardId(shardId);
            entry.addAttribute("key1", "value1");
            entry.addAttribute("key2", "value2");
            entry.setRecordData(new BlobRecordData(("testdata-" + cnt).getBytes()));
            recordEntries.add(entry);
        }
        PutRecordsResult putRecordsResult = this.client.putRecords("** datahub project **", "** datahub blob topic **", recordEntries);
        System.out.println("put failed record count: " + putRecordsResult.getFailedRecordCount());
        RecordSchema schema = new RecordSchema();
        schema.addField(new Field("field1", FieldType.STRING));
        schema.addField(new Field("field2", FieldType.BIGINT));
        schema.addField(new Field("field3", FieldType.BOOLEAN));
        recordEntries = new ArrayList();
        int cnt = 0;
        while (cnt < 10) {
            RecordEntry entry = new RecordEntry();
            entry.setShardId(shardId);
            entry.addAttribute("key1", "value1");
            entry.addAttribute("key2", "value2");
            final int fcopy = cnt++;
            TupleRecordData data = new TupleRecordData(schema){
                {
                    super(recordSchema);
                    this.setField("field1", (Object)("test-data-" + fcopy));
                    this.setField(1, (Object)fcopy);
                    this.setField(2, (Object)false);
                }
            };
            entry.setRecordData(data);
            recordEntries.add(entry);
        }
        putRecordsResult = this.client.putRecords("** datahub project **", "** datahub tuple topic **", recordEntries);
        System.out.println("put failed record count: " + putRecordsResult.getFailedRecordCount());
    }

    private void putRecordsByShardIntoTopic(String shardId) {
        this.enablePb = true;
        this.createClient();
        ArrayList<RecordEntry> recordEntries = new ArrayList<RecordEntry>();
        for (int cnt = 0; cnt < 10; ++cnt) {
            RecordEntry entry = new RecordEntry();
            entry.addAttribute("key1", "value1");
            entry.addAttribute("key2", "value2");
            entry.setRecordData(new BlobRecordData(("testdata-" + cnt).getBytes()));
            recordEntries.add(entry);
        }
        this.client.putRecordsByShard("** datahub project **", "** datahub blob topic **", shardId, recordEntries);
        RecordSchema schema = new RecordSchema();
        schema.addField(new Field("field1", FieldType.STRING));
        schema.addField(new Field("field2", FieldType.BIGINT));
        schema.addField(new Field("field3", FieldType.BOOLEAN));
        recordEntries = new ArrayList();
        int cnt = 0;
        while (cnt < 10) {
            RecordEntry entry = new RecordEntry();
            entry.addAttribute("key1", "value1");
            entry.addAttribute("key2", "value2");
            final int fcopy = cnt++;
            TupleRecordData data = new TupleRecordData(schema){
                {
                    super(recordSchema);
                    this.setField("field1", (Object)("test-data-" + fcopy));
                    this.setField(1, (Object)fcopy);
                    this.setField(2, (Object)false);
                }
            };
            entry.setRecordData(data);
            recordEntries.add(entry);
        }
        this.client.putRecordsByShard("** datahub project **", "** datahub tuple topic **", shardId, recordEntries);
    }

    private void getRecordsFromTopic(String shardId) {
        GetCursorResult getCursorResult = this.client.getCursor("** datahub project **", "** datahub blob topic **", shardId, CursorType.OLDEST);
        GetRecordsResult getRecordsResult = this.client.getRecords("** datahub project **", "** datahub blob topic **", shardId, getCursorResult.getCursor(), 10);
        System.out.println("Read count:" + getRecordsResult.getRecordCount());
        RecordSchema schema = new RecordSchema();
        schema.addField(new Field("field1", FieldType.STRING));
        schema.addField(new Field("field2", FieldType.BIGINT));
        schema.addField(new Field("field3", FieldType.STRING));
        getCursorResult = this.client.getCursor("** datahub project **", "** datahub tuple topic **", shardId, CursorType.SEQUENCE, 0L);
        getRecordsResult = this.client.getRecords("** datahub project **", "** datahub tuple topic **", shardId, schema, getCursorResult.getCursor(), 100);
        for (RecordEntry entry : getRecordsResult.getRecords()) {
            TupleRecordData data = (TupleRecordData)entry.getRecordData();
            System.out.println("field1:" + data.getField(0) + ", field2:" + data.getField("field2") + ", field3:" + data.getField(2));
        }
        System.out.println("Read count:" + getRecordsResult.getRecordCount());
    }
}

