/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.databend.util;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendOptions;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.databend.exception.DatabendConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.databend.exception.DatabendConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabendUtil {
    private static final Logger log = LoggerFactory.getLogger(DatabendUtil.class);
    public static final String DRIVER_NAME = "com.databend.jdbc.DatabendDriver";

    public static Connection createConnection(DatabendSourceConfig config) throws SQLException {
        try {
            return DriverManager.getConnection(config.getUrl(), config.getProperties());
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.CONNECT_FAILED, "Failed to create connection to Databend: " + e.getMessage(), e);
        }
    }

    public static Connection createConnection(DatabendSinkConfig config) throws SQLException {
        try {
            return DriverManager.getConnection(config.getUrl(), config.getProperties());
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.CONNECT_FAILED, "Failed to create connection to Databend: " + e.getMessage(), e);
        }
    }

    public static Connection createConnection(ReadonlyConfig config) throws SQLException {
        String url = (String)config.get(DatabendOptions.URL);
        Boolean ssl = config.getOptional(DatabendOptions.SSL).orElse(null);
        String username = (String)config.get(DatabendOptions.USERNAME);
        String password = (String)config.get(DatabendOptions.PASSWORD);
        Properties properties = new Properties();
        if (config.getOptional(DatabendOptions.JDBC_CONFIG).isPresent()) {
            Map jdbcConfig = (Map)config.get(DatabendOptions.JDBC_CONFIG);
            jdbcConfig.forEach(properties::setProperty);
        }
        if (!properties.containsKey("user")) {
            properties.setProperty("user", username);
        }
        if (!properties.containsKey("password")) {
            properties.setProperty("password", password);
        }
        if (ssl != null) {
            properties.setProperty("ssl", ssl.toString());
        }
        try {
            return DriverManager.getConnection(url, properties);
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.CONNECT_FAILED, "Failed to create connection to Databend: " + e.getMessage(), e);
        }
    }

    public static SeaTunnelRow convertToSeaTunnelRow(ResultSet resultSet, SeaTunnelRowType rowType) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("ResultSet cannot be null");
        }
        if (rowType == null) {
            throw new IllegalArgumentException("RowType cannot be null");
        }
        int arity = rowType.getFieldNames().length;
        Object[] fields = new Object[arity];
        log.info("Converting ResultSet to SeaTunnelRow with {} fields", (Object)arity);
        try {
            for (int i = 0; i < arity; ++i) {
                int columnIndex = i + 1;
                String fieldName = rowType.getFieldName(i);
                SeaTunnelDataType fieldType = rowType.getFieldType(i);
                try {
                    Object value;
                    fields[i] = value = DatabendUtil.getFieldValue(resultSet, columnIndex, fieldType);
                    if (value == null) {
                        log.info("Field {} ({}) [{}]: null", i, fieldName, fieldType.getSqlType());
                        continue;
                    }
                    log.info("Field {} ({}) [{}]: {} ({})", i, fieldName, fieldType.getSqlType(), value, value.getClass().getSimpleName());
                    continue;
                }
                catch (SQLException e) {
                    log.error("Error getting field {} ({}): {}", i, fieldName, e.getMessage());
                    fields[i] = null;
                }
            }
            SeaTunnelRow row = new SeaTunnelRow(fields);
            return row;
        }
        catch (Exception e) {
            log.error("Failed to convert ResultSet to SeaTunnelRow: {}", (Object)e.getMessage());
            throw new DatabendConnectorException(DatabendConnectorErrorCode.SQL_OPERATION_FAILED, "Failed to convert ResultSet to SeaTunnelRow: " + e.getMessage(), e);
        }
    }

    private static Object getFieldValue(ResultSet resultSet, int columnIndex, SeaTunnelDataType<?> fieldType) throws SQLException {
        try {
            if (fieldType instanceof BasicType) {
                BasicType basicType = (BasicType)fieldType;
                switch (basicType.getSqlType()) {
                    case STRING: {
                        return resultSet.getString(columnIndex);
                    }
                    case INT: {
                        int intValue = resultSet.getInt(columnIndex);
                        return resultSet.wasNull() ? null : Integer.valueOf(intValue);
                    }
                    case BIGINT: {
                        long longValue = resultSet.getLong(columnIndex);
                        return resultSet.wasNull() ? null : Long.valueOf(longValue);
                    }
                    case FLOAT: {
                        float floatValue = resultSet.getFloat(columnIndex);
                        return resultSet.wasNull() ? null : Float.valueOf(floatValue);
                    }
                    case DOUBLE: {
                        double doubleValue = resultSet.getDouble(columnIndex);
                        return resultSet.wasNull() ? null : Double.valueOf(doubleValue);
                    }
                    case BOOLEAN: {
                        boolean boolValue = resultSet.getBoolean(columnIndex);
                        return resultSet.wasNull() ? null : Boolean.valueOf(boolValue);
                    }
                    case BYTES: {
                        return resultSet.getBytes(columnIndex);
                    }
                }
                return resultSet.getObject(columnIndex);
            }
            if (fieldType instanceof LocalTimeType) {
                LocalTimeType localTimeType = (LocalTimeType)fieldType;
                switch (localTimeType.getSqlType()) {
                    case DATE: {
                        Date date = resultSet.getDate(columnIndex);
                        return date == null ? null : date.toLocalDate();
                    }
                    case TIME: {
                        Time time = resultSet.getTime(columnIndex);
                        return time == null ? null : time.toLocalTime();
                    }
                    case TIMESTAMP: {
                        Timestamp timestamp = resultSet.getTimestamp(columnIndex);
                        return timestamp == null ? null : timestamp.toLocalDateTime();
                    }
                }
                return resultSet.getObject(columnIndex);
            }
            if (fieldType instanceof DecimalType) {
                return resultSet.getBigDecimal(columnIndex);
            }
            return resultSet.getObject(columnIndex);
        }
        catch (SQLException e) {
            log.error("Error getting field value at index {}, type {}: {}", columnIndex, fieldType.getClass().getSimpleName(), e.getMessage());
            throw e;
        }
    }

    private static Object convertFromDatabendType(ResultSet resultSet, int index, SeaTunnelDataType<?> fieldType) throws SQLException {
        switch (fieldType.getSqlType()) {
            case STRING: {
                return resultSet.getString(index);
            }
            case BOOLEAN: {
                return resultSet.getBoolean(index);
            }
            case TINYINT: {
                return resultSet.getByte(index);
            }
            case SMALLINT: {
                return resultSet.getShort(index);
            }
            case INT: {
                return resultSet.getInt(index);
            }
            case BIGINT: {
                return resultSet.getLong(index);
            }
            case FLOAT: {
                return Float.valueOf(resultSet.getFloat(index));
            }
            case DOUBLE: {
                return resultSet.getDouble(index);
            }
            case DECIMAL: {
                return resultSet.getBigDecimal(index);
            }
            case DATE: {
                return resultSet.getDate(index);
            }
            case TIME: {
                return resultSet.getTime(index);
            }
            case TIMESTAMP: {
                return resultSet.getTimestamp(index);
            }
            case BYTES: {
                return resultSet.getBytes(index);
            }
        }
        return resultSet.getObject(index);
    }

    public static String generateTableExistsQuery(String database, String table) {
        StringBuilder sql = new StringBuilder("SELECT 1 FROM information_schema.tables WHERE ");
        if (database != null && !database.isEmpty()) {
            sql.append("table_schema = '").append(database).append("' AND ");
        }
        sql.append("table_name = '").append(table).append("' LIMIT 1");
        return sql.toString();
    }

    /*
     * Exception decompiling
     */
    public static boolean tableExists(Connection connection, String database, String table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String generateInsertSql(String database, String table, CatalogTable catalogTable) {
        SeaTunnelRowType rowType = catalogTable.getSeaTunnelRowType();
        String[] fieldNames = rowType.getFieldNames();
        String columns = Arrays.stream(fieldNames).map(name -> "`" + name + "`").collect(Collectors.joining(", "));
        String placeholders = Arrays.stream(fieldNames).map(field -> "?").collect(Collectors.joining(", "));
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("INSERT INTO ");
        if (database != null && !database.isEmpty()) {
            sqlBuilder.append(database).append(".");
        }
        sqlBuilder.append(table);
        sqlBuilder.append(" (").append(columns).append(") ");
        sqlBuilder.append("VALUES (").append(placeholders).append(")");
        return sqlBuilder.toString();
    }

    public static List<String> getTableColumns(Connection connection, String database, String table) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT column_name FROM information_schema.columns WHERE ");
        if (database != null && !database.isEmpty()) {
            sql.append("table_schema = '").append(database).append("' AND ");
        }
        sql.append("table_name = '").append(table).append("' ORDER BY ordinal_position");
        ArrayList<String> columns = new ArrayList<String>();
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                columns.add(resultSet.getString("column_name"));
            }
        }
        return columns;
    }

    public static void closeQuietly(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                log.warn("Error while closing resource: {}", (Object)e.getMessage());
            }
        }
    }

    static {
        try {
            Class.forName(DRIVER_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.CONNECT_FAILED, "Failed to load Databend JDBC driver: " + e.getMessage(), e);
        }
    }
}

