/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.databend.source;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.databend.source.DatabendSourceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabendSource
extends AbstractSingleSplitSource<SeaTunnelRow> {
    private static final Logger log = LoggerFactory.getLogger(DatabendSource.class);
    private final CatalogTable catalogTable;
    private final String sql;
    private final String jdbcUrl;
    private final Boolean ssl;
    private final String username;
    private final String password;
    private final Integer fetchSize;
    private SeaTunnelRowType rowTypeInfo;
    private DatabendSourceReader reader;

    public DatabendSource(CatalogTable catalogTable, String sql, String url, Boolean ssl, String username, String password, Integer fetchSize) {
        Objects.requireNonNull(catalogTable, "catalogTable cannot be null");
        Objects.requireNonNull(url, "jdbcUrl cannot be null");
        log.info("sjh-Databend jdbcUrl: {}", (Object)url);
        this.catalogTable = catalogTable;
        this.sql = sql;
        this.jdbcUrl = url;
        this.ssl = ssl;
        this.username = username;
        this.password = password;
        this.fetchSize = fetchSize;
        this.rowTypeInfo = catalogTable.getSeaTunnelRowType();
    }

    public String getPluginName() {
        return "Databend";
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        if (this.reader != null && this.reader.getRowType() != null) {
            TableSchema.Builder builder = TableSchema.builder();
            SeaTunnelRowType inferredRowType = this.reader.getRowType();
            for (int i = 0; i < inferredRowType.getFieldNames().length; ++i) {
                PhysicalColumn column = PhysicalColumn.builder().name(inferredRowType.getFieldNames()[i]).dataType(inferredRowType.getFieldTypes()[i]).nullable(true).build();
                builder.column((Column)column);
            }
            TableSchema tableSchema = builder.build();
            CatalogTable updatedCatalogTable = CatalogTable.of((TableIdentifier)this.catalogTable.getTableId(), (TableSchema)tableSchema, (Map)this.catalogTable.getOptions(), (List)this.catalogTable.getPartitionKeys(), (String)this.catalogTable.getComment(), (String)this.catalogTable.getCatalogName());
            return Collections.singletonList(updatedCatalogTable);
        }
        return Collections.singletonList(this.catalogTable);
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) {
        DatabendSourceConfig sourceConfig = new DatabendSourceConfig();
        sourceConfig.setUrl(this.jdbcUrl);
        sourceConfig.setUsername(this.username);
        sourceConfig.setPassword(this.password);
        sourceConfig.setSsl(this.ssl);
        sourceConfig.setFetchSize(this.fetchSize);
        Properties properties = new Properties();
        properties.setProperty("user", this.username);
        properties.setProperty("password", this.password);
        if (this.ssl != null) {
            properties.setProperty("ssl", this.ssl.toString());
        }
        sourceConfig.setProperties(properties);
        this.reader = new DatabendSourceReader(readerContext, sourceConfig, this.sql, this.rowTypeInfo);
        return this.reader;
    }
}

