/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc.cloud;

public class ExternalLocationS3 {
    private final String location;
    private final String endpointUrl;
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final String region;
    private final boolean enableVirtualHostStyle;

    private ExternalLocationS3(String location, String endpointUrl, String accessKeyId, String secretAccessKey, String sessionToken, String region, boolean enableVirtualHostStyle) {
        this.location = location;
        this.endpointUrl = endpointUrl;
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.region = region;
        this.enableVirtualHostStyle = enableVirtualHostStyle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLocation() {
        return this.location;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean isEnableVirtualHostStyle() {
        return this.enableVirtualHostStyle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String loc = "'" + this.location + "'";
        sb.append(loc);
        sb.append(" CONNECTION = (");
        if (this.endpointUrl != null) {
            sb.append("ENDPOINT_URL = '");
            sb.append(this.endpointUrl);
            sb.append("'");
            sb.append(" ");
        }
        if (this.accessKeyId != null) {
            sb.append("ACCESS_KEY_ID = '");
            sb.append(this.accessKeyId);
            sb.append("'");
            sb.append(" ");
        }
        if (this.secretAccessKey != null) {
            sb.append("SECRET_ACCESS_KEY = '");
            sb.append(this.secretAccessKey);
            sb.append("'");
            sb.append(" ");
        }
        if (this.sessionToken != null) {
            sb.append("SESSION_TOKEN = '");
            sb.append(this.sessionToken);
            sb.append("'");
            sb.append(" ");
        }
        if (this.region != null) {
            sb.append("REGION = '");
            sb.append(this.region);
            sb.append("'");
            sb.append(" ");
        }
        sb.append("ENABLE_VIRTUAL_HOST_STYLE = '");
        sb.append(this.enableVirtualHostStyle);
        sb.append("'");
        sb.append(" ");
        sb.append(")");
        return sb.toString();
    }

    public static class Builder {
        private String location;
        private String endpointUrl;
        private String accessKeyId;
        private String secretAccessKey;
        private String sessionToken;
        private String region;
        private boolean enableVirtualHostStyle;

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public Builder setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public Builder setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setEnableVirtualHostStyle(boolean enableVirtualHostStyle) {
            this.enableVirtualHostStyle = enableVirtualHostStyle;
            return this;
        }

        public ExternalLocationS3 build() {
            return new ExternalLocationS3(this.location, this.endpointUrl, this.accessKeyId, this.secretAccessKey, this.sessionToken, this.region, this.enableVirtualHostStyle);
        }
    }
}

