/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.jdbc.RawStatement;
import com.databend.jdbc.SetParamRawStatement;
import com.databend.jdbc.StatementType;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;

public class StatementInfoWrapper {
    private String sql;
    private String id;
    private StatementType type;
    private Pair<String, String> param;
    private RawStatement initialStatement;

    public static StatementInfoWrapper of(@NonNull RawStatement rawStatement) {
        if (rawStatement == null) {
            throw new NullPointerException("rawStatement is marked non-null but is null");
        }
        return StatementInfoWrapper.of(rawStatement, UUID.randomUUID().toString());
    }

    public static StatementInfoWrapper of(@NonNull RawStatement rawStatement, String id) {
        if (rawStatement == null) {
            throw new NullPointerException("rawStatement is marked non-null but is null");
        }
        Pair<String, String> additionalProperties = rawStatement.getStatementType() == StatementType.PARAM_SETTING ? ((SetParamRawStatement)rawStatement).getAdditionalProperty() : null;
        return new StatementInfoWrapper(rawStatement.getSql(), id, rawStatement.getStatementType(), additionalProperties, rawStatement);
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public StatementType getType() {
        return this.type;
    }

    @Generated
    public Pair<String, String> getParam() {
        return this.param;
    }

    @Generated
    public RawStatement getInitialStatement() {
        return this.initialStatement;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setType(StatementType type) {
        this.type = type;
    }

    @Generated
    public void setParam(Pair<String, String> param) {
        this.param = param;
    }

    @Generated
    public void setInitialStatement(RawStatement initialStatement) {
        this.initialStatement = initialStatement;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatementInfoWrapper)) {
            return false;
        }
        StatementInfoWrapper other = (StatementInfoWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        StatementType this$type = this.getType();
        StatementType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Pair<String, String> this$param = this.getParam();
        Pair<String, String> other$param = other.getParam();
        if (this$param == null ? other$param != null : !((Object)this$param).equals(other$param)) {
            return false;
        }
        RawStatement this$initialStatement = this.getInitialStatement();
        RawStatement other$initialStatement = other.getInitialStatement();
        return !(this$initialStatement == null ? other$initialStatement != null : !((Object)this$initialStatement).equals(other$initialStatement));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StatementInfoWrapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        StatementType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Pair<String, String> $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : ((Object)$param).hashCode());
        RawStatement $initialStatement = this.getInitialStatement();
        result = result * 59 + ($initialStatement == null ? 43 : ((Object)$initialStatement).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StatementInfoWrapper(sql=" + this.getSql() + ", id=" + this.getId() + ", type=" + (Object)((Object)this.getType()) + ", param=" + this.getParam() + ", initialStatement=" + this.getInitialStatement() + ")";
    }

    @ConstructorProperties(value={"sql", "id", "type", "param", "initialStatement"})
    @Generated
    public StatementInfoWrapper(String sql, String id, StatementType type, Pair<String, String> param, RawStatement initialStatement) {
        this.sql = sql;
        this.id = id;
        this.type = type;
        this.param = param;
        this.initialStatement = initialStatement;
    }
}

