/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.jdbc.DatabendConnection;
import com.databend.jdbc.DatabendResultSet;
import com.databend.jdbc.com.fasterxml.jackson.core.JsonProcessingException;
import com.databend.jdbc.com.fasterxml.jackson.databind.ObjectMapper;
import com.google.shaded.common.base.MoreObjects;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.Headers;

public final class PresignContext {
    private final PresignMethod method;
    private final String stageName;
    private final String fileName;
    private final Headers headers;
    private final String url;

    private PresignContext(PresignMethod method, String stageName, String fileName, Headers headers2, String url) {
        this.method = method;
        this.stageName = stageName;
        this.fileName = fileName;
        this.headers = headers2;
        this.url = url;
    }

    public static void createStageIfNotExists(DatabendConnection connection, String stageName) throws SQLException {
        String sql = String.format("CREATE STAGE IF NOT EXISTS %s", stageName);
        Statement statement = connection.createStatement();
        statement.execute(sql);
    }

    public static void dropStageIfExists(DatabendConnection connection, String stageName) throws SQLException {
        String sql = String.format("DROP STAGE IF EXISTS %s", stageName);
        Statement statement = connection.createStatement();
        statement.execute(sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PresignContext getPresignContext(DatabendConnection connection, PresignMethod method, String stageName, String fileName) throws SQLException {
        Objects.requireNonNull(connection, "connection is null");
        Objects.requireNonNull(method, "method is null");
        try (Statement statement = connection.createStatement();){
            String sql = PresignContext.buildRequestSQL(method, stageName, fileName);
            DatabendResultSet resultSet = (DatabendResultSet)statement.executeQuery(sql);
            if (!resultSet.next()) throw new SQLException("Failed to get presign url. No result returned for SQL: " + sql);
            Headers headers2 = PresignContext.getHeaders(resultSet.getString("headers"));
            String url = resultSet.getString("url");
            PresignContext presignContext = PresignContext.builder().method(method).stageName(stageName).fileName(fileName).headers(headers2).url(url).build();
            return presignContext;
        }
        catch (SQLException sqlException) {
            throw new SQLException("Failed to do presign. SQL Exception: " + sqlException.getMessage() + " SQL State: " + sqlException.getSQLState() + " Error Code: " + sqlException.getErrorCode() + " method: " + (Object)((Object)method) + ", stageName: " + stageName + ", fileName: " + fileName, sqlException);
        }
        catch (Throwable e) {
            throw new SQLException("Failed to do presign. Exception: " + e + " method: " + (Object)((Object)method) + ", stageName: " + stageName + ", fileName: " + fileName, e);
        }
    }

    public static String buildRequestSQL(PresignMethod method, String stageName, String fileName) {
        StringBuilder sql = new StringBuilder("PRESIGN ");
        sql.append(PresignContext.presignMethod(method));
        sql.append(" ");
        sql.append("@");
        if (stageName != null) {
            sql.append(stageName);
            sql.append("/");
        } else {
            sql.append("~/");
        }
        sql.append(fileName);
        return sql.toString();
    }

    private static String presignMethod(PresignMethod method) {
        switch (method.ordinal()) {
            case 0: {
                return "UPLOAD";
            }
        }
        return "DOWNLOAD";
    }

    private static Headers getHeaders(String headers2) throws JsonProcessingException {
        Map resp = new ObjectMapper().readValue(headers2, HashMap.class);
        Headers.Builder builder = new Headers.Builder();
        for (Map.Entry entry : resp.entrySet()) {
            builder.add((String)entry.getKey(), entry.getValue().toString());
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("method", (Object)this.method).add("stageName", this.stageName).add("fileName", this.fileName).add("headers", this.headers).add("url", this.url).toString();
    }

    public PresignMethod getMethod() {
        return this.method;
    }

    public String getStageName() {
        return this.stageName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getUrl() {
        return this.url;
    }

    static enum PresignMethod {
        UPLOAD,
        DOWNLOAD;

    }

    public static class Builder {
        private PresignMethod method;
        private String stageName;
        private String fileName;
        private long fileSize;
        private Headers headers;
        private String url;

        public Builder method(PresignMethod method) {
            this.method = method;
            return this;
        }

        public Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public Builder headers(Headers headers2) {
            this.headers = headers2;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public PresignContext build() {
            return new PresignContext(this.method, this.stageName, this.fileName, this.headers, this.url);
        }
    }
}

