/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.utils;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDiscoveryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TableDiscoveryUtils.class);

    public static List<TableId> listTables(JdbcConnection jdbc, RelationalTableFilters tableFilters) throws SQLException {
        ArrayList<TableId> capturedTableIds = new ArrayList<TableId>();
        LOG.info("Read list of available databases");
        ArrayList databaseNames = new ArrayList();
        jdbc.query("SELECT name, database_id, create_date  \nFROM sys.databases;  ", rs -> {
            while (rs.next()) {
                databaseNames.add(rs.getString(1));
            }
        });
        LOG.info("\t list of available databases is: {}", databaseNames);
        LOG.info("Read list of available tables in each database");
        for (String dbName : databaseNames) {
            try {
                jdbc.query("SELECT * FROM " + dbName + ".INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE = 'BASE TABLE';", rs -> {
                    while (rs.next()) {
                        TableId tableId = new TableId(rs.getString(1), rs.getString(2), rs.getString(3));
                        if (tableFilters.dataCollectionFilter().isIncluded(tableId)) {
                            capturedTableIds.add(tableId);
                            LOG.info("\t including '{}' for further processing", (Object)tableId);
                            continue;
                        }
                        LOG.debug("\t '{}' is filtered out of capturing", (Object)tableId);
                    }
                });
            }
            catch (SQLException e) {
                LOG.warn("\t skipping database '{}' due to error reading tables: {}", (Object)dbName, (Object)e.getMessage());
            }
        }
        return capturedTableIds;
    }
}

