/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger log = LoggerFactory.getLogger(RetryUtil.class);

    public static <T> T retryUntilTimeout(Callable<T> callable, Supplier<String> description, Duration timeoutDuration, long retryBackoffMs) throws Exception {
        String descriptionStr = Optional.ofNullable(description).map(Supplier::get).orElse("callable");
        long timeoutMs = Optional.ofNullable(timeoutDuration).map(Duration::toMillis).orElse(0L);
        if (retryBackoffMs < 0L) {
            log.debug("Assuming no retry backoff since retryBackoffMs={} is negative", (Object)retryBackoffMs);
            retryBackoffMs = 0L;
        }
        if (timeoutMs <= 0L || retryBackoffMs >= timeoutMs) {
            log.debug("Executing {} only once, since timeoutMs={} is not larger than retryBackoffMs={}", new Object[]{descriptionStr, timeoutMs, retryBackoffMs});
            return callable.call();
        }
        long end = System.currentTimeMillis() + timeoutMs;
        int attempt = 0;
        KafkaException lastError = null;
        do {
            ++attempt;
            try {
                return callable.call();
            }
            catch (RetriableException | org.apache.kafka.connect.errors.RetriableException e) {
                log.warn("Attempt {} to {} resulted in RetriableException; retrying automatically. Reason: {}", new Object[]{attempt, descriptionStr, e.getMessage(), e});
                lastError = e;
            }
            catch (WakeupException e) {
                lastError = e;
            }
            if (retryBackoffMs <= 0L) continue;
            long millisRemaining = Math.max(0L, end - System.currentTimeMillis());
            if (millisRemaining < retryBackoffMs) break;
            Utils.sleep(retryBackoffMs);
        } while (System.currentTimeMillis() < end);
        throw new ConnectException("Fail to " + descriptionStr + " after " + attempt + " attempts.  Reason: " + lastError.getMessage(), lastError);
    }
}

