/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonDeserializer
implements Deserializer<JsonNode> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonDeserializer() {
        this(Collections.emptySet(), JsonNodeFactory.withExactBigDecimals(true));
    }

    JsonDeserializer(Set<DeserializationFeature> deserializationFeatures, JsonNodeFactory jsonNodeFactory) {
        deserializationFeatures.forEach(this.objectMapper::enable);
        this.objectMapper.setNodeFactory(jsonNodeFactory);
    }

    @Override
    public JsonNode deserialize(String topic, byte[] bytes) {
        JsonNode data;
        if (bytes == null) {
            return null;
        }
        try {
            data = this.objectMapper.readTree(bytes);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
        return data;
    }
}

