/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.codec;

import java.util.HashMap;
import java.util.List;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.row.ObjectRowImpl;
import org.tikv.common.row.Row;
import org.tikv.common.types.DataType;
import org.tikv.common.types.IntegerType;

public class TableCodecV1 {
    protected static byte[] encodeRow(List<TiColumnInfo> columnInfos, Object[] values, boolean isPkHandle) {
        CodecDataOutput cdo = new CodecDataOutput();
        for (int i = 0; i < columnInfos.size(); ++i) {
            TiColumnInfo col = columnInfos.get(i);
            if (col.isPrimaryKey() && isPkHandle) continue;
            Codec.IntegerCodec.writeLongFully(cdo, col.getId(), false);
            col.getType().encode(cdo, DataType.EncodeType.VALUE, values[i]);
        }
        if (cdo.toBytes().length == 0) {
            return new byte[]{0};
        }
        return cdo.toBytes();
    }

    protected static Object[] decodeObjects(byte[] value, Long handle, TiTableInfo tableInfo) {
        if (handle == null && tableInfo.isPkHandle()) {
            throw new IllegalArgumentException("when pk is handle, handle cannot be null");
        }
        int colSize = tableInfo.getColumns().size();
        HashMap<Long, TiColumnInfo> idToColumn = new HashMap<Long, TiColumnInfo>(colSize);
        for (TiColumnInfo col : tableInfo.getColumns()) {
            idToColumn.put(col.getId(), col);
        }
        HashMap<Long, Object> decodedDataMap = new HashMap<Long, Object>(colSize);
        CodecDataInput cdi = new CodecDataInput(value);
        Object[] res = new Object[colSize];
        while (!cdi.eof()) {
            long colID = (Long)IntegerType.BIGINT.decode(cdi);
            Object colValue = ((TiColumnInfo)idToColumn.get(colID)).getType().decodeForBatchWrite(cdi);
            decodedDataMap.put(colID, colValue);
        }
        for (int i = 0; i < colSize; ++i) {
            TiColumnInfo col = tableInfo.getColumn(i);
            res[i] = col.isPrimaryKey() && tableInfo.isPkHandle() ? handle : decodedDataMap.get(col.getId());
        }
        return res;
    }

    protected static Row decodeRow(byte[] value, Long handle, TiTableInfo tableInfo) {
        return ObjectRowImpl.create(TableCodecV1.decodeObjects(value, handle, tableInfo));
    }
}

