/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.source.split;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceRecords;
import org.apache.seatunnel.connectors.seatunnel.common.source.reader.RecordsWithSplitIds;

public final class ChangeEventRecords
implements RecordsWithSplitIds<SourceRecords> {
    private String splitId;
    private Iterator<SourceRecords> recordsForCurrentSplit;
    private final Iterator<SourceRecords> recordsForSplit;
    private final Set<String> finishedSnapshotSplits;

    public ChangeEventRecords(String splitId, Iterator recordsForSplit, Set<String> finishedSnapshotSplits) {
        this.splitId = splitId;
        this.recordsForSplit = recordsForSplit;
        this.finishedSnapshotSplits = finishedSnapshotSplits;
    }

    @Override
    public String nextSplit() {
        String nextSplit = this.splitId;
        this.splitId = null;
        this.recordsForCurrentSplit = nextSplit != null ? this.recordsForSplit : null;
        return nextSplit;
    }

    @Override
    public SourceRecords nextRecordFromSplit() {
        Iterator<SourceRecords> recordsForSplit = this.recordsForCurrentSplit;
        if (recordsForSplit != null) {
            if (recordsForSplit.hasNext()) {
                return recordsForSplit.next();
            }
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public Set<String> finishedSplits() {
        return this.finishedSnapshotSplits;
    }

    public static ChangeEventRecords forRecords(String splitId, Iterator<SourceRecords> recordsForSplit) {
        return new ChangeEventRecords(splitId, recordsForSplit, Collections.emptySet());
    }

    public static ChangeEventRecords forFinishedSplit(String splitId) {
        return new ChangeEventRecords(null, null, Collections.singleton(splitId));
    }
}

