/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver.metrics;

import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.metrics.AbstractSqlServerPartitionMetrics;
import io.debezium.connector.sqlserver.metrics.SqlServerTaskMetricsMXBean;
import io.debezium.data.Envelope;
import io.debezium.metrics.Metrics;
import io.debezium.pipeline.ConnectorEvent;
import io.debezium.pipeline.metrics.ChangeEventSourceMetrics;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.connect.data.Struct;

abstract class AbstractSqlServerTaskMetrics<B extends AbstractSqlServerPartitionMetrics>
extends Metrics
implements ChangeEventSourceMetrics<SqlServerPartition>,
SqlServerTaskMetricsMXBean {
    private final ChangeEventQueueMetrics changeEventQueueMetrics;
    private final Map<SqlServerPartition, B> beans = new HashMap<SqlServerPartition, B>();

    AbstractSqlServerTaskMetrics(CdcSourceTaskContext taskContext, String contextName, ChangeEventQueueMetrics changeEventQueueMetrics, Collection<SqlServerPartition> partitions, Function<SqlServerPartition, B> beanFactory) {
        super(taskContext, Collect.linkMapOf("server", taskContext.getConnectorName(), "task", taskContext.getTaskId(), "context", contextName));
        this.changeEventQueueMetrics = changeEventQueueMetrics;
        for (SqlServerPartition partition : partitions) {
            this.beans.put(partition, (AbstractSqlServerPartitionMetrics)beanFactory.apply(partition));
        }
    }

    @Override
    public synchronized void register() {
        super.register();
        this.beans.values().forEach(Metrics::register);
    }

    @Override
    public synchronized void unregister() {
        this.beans.values().forEach(Metrics::unregister);
        super.unregister();
    }

    @Override
    public void reset() {
        this.beans.values().forEach(AbstractSqlServerPartitionMetrics::reset);
    }

    @Override
    public void onEvent(SqlServerPartition partition, DataCollectionId source, OffsetContext offset, Object key, Struct value, Envelope.Operation operation) {
        this.onPartitionEvent(partition, bean -> bean.onEvent(source, offset, key, value, operation));
    }

    @Override
    public void onFilteredEvent(SqlServerPartition partition, String event) {
        this.onPartitionEvent(partition, bean -> bean.onFilteredEvent(event));
    }

    @Override
    public void onFilteredEvent(SqlServerPartition partition, String event, Envelope.Operation operation) {
        this.onPartitionEvent(partition, bean -> bean.onFilteredEvent(event, operation));
    }

    @Override
    public void onErroneousEvent(SqlServerPartition partition, String event) {
        this.onPartitionEvent(partition, bean -> bean.onErroneousEvent(event));
    }

    @Override
    public void onErroneousEvent(SqlServerPartition partition, String event, Envelope.Operation operation) {
        this.onPartitionEvent(partition, bean -> bean.onErroneousEvent(event, operation));
    }

    @Override
    public void onConnectorEvent(SqlServerPartition partition, ConnectorEvent event) {
        this.onPartitionEvent(partition, bean -> bean.onConnectorEvent(event));
    }

    @Override
    public int getQueueTotalCapacity() {
        return this.changeEventQueueMetrics.totalCapacity();
    }

    @Override
    public int getQueueRemainingCapacity() {
        return this.changeEventQueueMetrics.remainingCapacity();
    }

    @Override
    public long getMaxQueueSizeInBytes() {
        return this.changeEventQueueMetrics.maxQueueSizeInBytes();
    }

    @Override
    public long getCurrentQueueSizeInBytes() {
        return this.changeEventQueueMetrics.currentQueueSizeInBytes();
    }

    protected void onPartitionEvent(SqlServerPartition partition, Consumer<B> handler) {
        AbstractSqlServerPartitionMetrics bean = (AbstractSqlServerPartitionMetrics)this.beans.get(partition);
        if (bean == null) {
            throw new IllegalArgumentException("MBean for partition " + partition + " are not registered");
        }
        handler.accept(bean);
    }
}

