/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.presto;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;

public class PrestoTypeMapper
implements JdbcDialectTypeMapper {
    private static final String PRESTO_BOOLEAN = "BOOLEAN";
    private static final String PRESTO_ARRAY = "ARRAY";
    private static final String PRESTO_MAP = "MAP";
    private static final String PRESTO_ROW = "ROW";
    private static final String PRESTO_TINYINT = "TINYINT";
    private static final String PRESTO_SMALLINT = "SMALLINT";
    private static final String PRESTO_INTEGER = "INTEGER";
    private static final String PRESTO_BIGINT = "BIGINT";
    private static final String PRESTO_DECIMAL = "DECIMAL";
    private static final String PRESTO_REAL = "REAL";
    private static final String PRESTO_DOUBLE = "DOUBLE";
    private static final String PRESTO_CHAR = "CHAR";
    private static final String PRESTO_VARCHAR = "VARCHAR";
    private static final String PRESTO_JSON = "JSON";
    private static final String PRESTO_DATE = "DATE";
    private static final String PRESTO_TIME = "TIME";
    private static final String PRESTO_TIMESTAMP = "TIMESTAMP";
    private static final String PRESTO_BINARY = "BINARY";
    private static final String PRESTO_VARBINARY = "VARBINARY";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String columnType = metadata.getColumnTypeName(colIndex).toUpperCase();
        if (columnType.indexOf("(") > -1) {
            columnType = columnType.split("\\(")[0];
        }
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (columnType) {
            case "BOOLEAN": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "TINYINT": {
                return BasicType.BYTE_TYPE;
            }
            case "INTEGER": {
                return BasicType.INT_TYPE;
            }
            case "SMALLINT": {
                return BasicType.SHORT_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "DECIMAL": {
                return new DecimalType(precision, scale);
            }
            case "REAL": {
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "CHAR": 
            case "VARCHAR": 
            case "JSON": {
                return BasicType.STRING_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "TIMESTAMP": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "VARBINARY": 
            case "BINARY": {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw CommonError.convertToSeaTunnelTypeError((String)"Presto", (String)columnType, (String)jdbcColumnName);
    }
}

