/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.saphana;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;

public class SapHanaURLParser {
    private static final Pattern HANA_URL_PATTERN = Pattern.compile("^(?<url>jdbc:sap://(?<host>[^:]+):(?<port>\\d+)/\\?(?<params>.*?))$");

    public static JdbcUrlUtil.UrlInfo parse(String url) {
        Matcher matcher = HANA_URL_PATTERN.matcher(url);
        if (matcher.find()) {
            String urlWithoutDatabase = matcher.group("url");
            String host = matcher.group("host");
            Integer port = Integer.valueOf(matcher.group("port"));
            String params = matcher.group("params");
            return new JdbcUrlUtil.UrlInfo(url, urlWithoutDatabase, host, port, "SYSTEM", params);
        }
        return new JdbcUrlUtil.UrlInfo(url, url, null, null, "SYSTEM", null);
    }
}

