/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.operation.iterator;

import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorCompletionService;
import org.tikv.common.Snapshot;
import org.tikv.common.TiConfiguration;
import org.tikv.common.TiSession;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.meta.TiDAGRequest;
import org.tikv.common.operation.iterator.CoprocessorIterator;
import org.tikv.common.row.Row;
import org.tikv.common.util.RangeSplitter;

public class IndexScanIterator
implements Iterator<Row> {
    private final Iterator<Long> handleIterator;
    private final TiDAGRequest dagReq;
    private final Snapshot snapshot;
    private final ExecutorCompletionService<Iterator<Row>> completionService;
    private final int batchSize;
    private Iterator<Row> rowIterator;
    private int batchCount = 0;

    public IndexScanIterator(Snapshot snapshot, TiDAGRequest req, Iterator<Long> handleIterator) {
        TiSession session = snapshot.getSession();
        TiConfiguration conf = session.getConf();
        this.dagReq = req;
        this.handleIterator = handleIterator;
        this.snapshot = snapshot;
        this.batchSize = conf.getIndexScanBatchSize();
        this.completionService = new ExecutorCompletionService(session.getThreadPoolForIndexScan());
    }

    private TLongArrayList feedBatch() {
        TLongArrayList handles = new TLongArrayList(512);
        while (this.handleIterator.hasNext()) {
            handles.add(this.handleIterator.next());
            if (this.batchSize > handles.size()) continue;
            break;
        }
        return handles;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.rowIterator == null) {
                TiSession session = this.snapshot.getSession();
                while (this.handleIterator.hasNext()) {
                    TLongArrayList handles = this.feedBatch();
                    ++this.batchCount;
                    this.completionService.submit(() -> {
                        ArrayList<RangeSplitter.RegionTask> tasks = new ArrayList<RangeSplitter.RegionTask>();
                        List<Long> ids = this.dagReq.getPrunedPhysicalIds();
                        tasks.addAll(RangeSplitter.newSplitter(session.getRegionManager()).splitAndSortHandlesByRegion(ids, handles));
                        return CoprocessorIterator.getRowIterator(this.dagReq, tasks, session);
                    });
                }
                while (this.batchCount > 0) {
                    this.rowIterator = this.completionService.take().get();
                    --this.batchCount;
                    if (!this.rowIterator.hasNext()) continue;
                    return true;
                }
            }
            if (this.rowIterator == null) {
                return false;
            }
        }
        catch (Exception e) {
            throw new TiClientInternalException("Error reading rows from handle", e);
        }
        return this.rowIterator.hasNext();
    }

    @Override
    public Row next() {
        if (this.hasNext()) {
            return this.rowIterator.next();
        }
        throw new NoSuchElementException();
    }
}

