/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.columnar.datatypes;

import java.nio.ByteBuffer;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.util.MemoryUtil;

public class AutoGrowByteBuffer {
    private ByteBuffer buf;

    public AutoGrowByteBuffer(ByteBuffer initBuf) {
        initBuf.clear();
        this.buf = initBuf;
    }

    public int dataSize() {
        return this.buf.position();
    }

    public ByteBuffer getByteBuffer() {
        return this.buf;
    }

    private void beforeIncrease(int inc) {
        int newCap;
        int minCap = this.buf.position() + inc;
        if (minCap > (newCap = this.buf.capacity())) {
            while (minCap > (newCap <<= 1)) {
            }
            this.buf = MemoryUtil.copyOf(this.buf, newCap);
        }
    }

    public void put(CodecDataInput cdi, int len) {
        this.beforeIncrease(len);
        this.buf.limit(this.buf.position() + len);
        MemoryUtil.readFully(this.buf, cdi, len);
    }

    public void putByte(byte v) {
        this.beforeIncrease(1);
        this.buf.limit(this.buf.position() + 1);
        this.buf.put(v);
    }
}

