/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.StringSplitMode;

public interface JdbcOptions {
    public static final Option<String> URL = Options.key((String)"url").stringType().noDefaultValue().withDescription("url");
    public static final Option<String> DRIVER = Options.key((String)"driver").stringType().noDefaultValue().withDescription("driver");
    public static final Option<Integer> CONNECTION_CHECK_TIMEOUT_SEC = Options.key((String)"connection_check_timeout_sec").intType().defaultValue((Object)30).withDescription("connection check time second");
    public static final Option<String> COMPATIBLE_MODE = Options.key((String)"compatible_mode").stringType().noDefaultValue().withDescription("The compatible mode of database, required when the database supports multiple compatible modes. For example, when using OceanBase database, you need to set it to 'mysql' or 'oracle'.");
    public static final Option<Integer> MAX_RETRIES = Options.key((String)"max_retries").intType().defaultValue((Object)0).withDescription("max_retired");
    public static final Option<String> USER = Options.key((String)"user").stringType().noDefaultValue().withDescription("user");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("password");
    public static final Option<String> QUERY = Options.key((String)"query").stringType().noDefaultValue().withDescription("query");
    public static final Option<SchemaSaveMode> SCHEMA_SAVE_MODE = Options.key((String)"schema_save_mode").enumType(SchemaSaveMode.class).defaultValue((Object)SchemaSaveMode.CREATE_SCHEMA_WHEN_NOT_EXIST).withDescription("schema_save_mode");
    public static final Option<DataSaveMode> DATA_SAVE_MODE = Options.key((String)"data_save_mode").enumType(DataSaveMode.class).defaultValue((Object)DataSaveMode.APPEND_DATA).withDescription("data_save_mode");
    public static final Option<String> CUSTOM_SQL = Options.key((String)"custom_sql").stringType().noDefaultValue().withDescription("custom_sql");
    public static final Option<Boolean> AUTO_COMMIT = Options.key((String)"auto_commit").booleanType().defaultValue((Object)true).withDescription("auto commit");
    public static final Option<Integer> BATCH_SIZE = Options.key((String)"batch_size").intType().defaultValue((Object)1000).withDescription("batch size");
    public static final Option<Integer> FETCH_SIZE = Options.key((String)"fetch_size").intType().defaultValue((Object)0).withDescription("For queries that return a large number of objects, you can configure the row fetch size used in the query to improve performance by reducing the number database hits required to satisfy the selection criteria. Zero means use jdbc default value.");
    public static final Option<Boolean> IS_EXACTLY_ONCE = Options.key((String)"is_exactly_once").booleanType().defaultValue((Object)false).withDescription("exactly once");
    public static final Option<Boolean> GENERATE_SINK_SQL = Options.key((String)"generate_sink_sql").booleanType().defaultValue((Object)false).withDescription("generate sql using the database table");
    public static final Option<Boolean> DECIMAL_TYPE_NARROWING = Options.key((String)"decimal_type_narrowing").booleanType().defaultValue((Object)true).withDescription("decimal type narrowing, if true, the decimal type will be narrowed to the int or long type if without loss of precision. Only support for Oracle at now.");
    public static final Option<Boolean> HANDLE_BLOB_AS_STRING = Options.key((String)"handle_blob_as_string").booleanType().defaultValue((Object)false).withDescription("If true, BLOB type will be converted to STRING type. Only support for Oracle at now.");
    public static final Option<String> XA_DATA_SOURCE_CLASS_NAME = Options.key((String)"xa_data_source_class_name").stringType().noDefaultValue().withDescription("data source class name");
    public static final Option<Integer> MAX_COMMIT_ATTEMPTS = Options.key((String)"max_commit_attempts").intType().defaultValue((Object)3).withDescription("max commit attempts");
    public static final Option<Integer> TRANSACTION_TIMEOUT_SEC = Options.key((String)"transaction_timeout_sec").intType().defaultValue((Object)-1).withDescription("transaction timeout (second)");
    public static final Option<String> DATABASE = Options.key((String)"database").stringType().noDefaultValue().withDescription("database");
    public static final Option<String> TABLE = Options.key((String)"table").stringType().noDefaultValue().withDescription("table");
    public static final Option<List<String>> PRIMARY_KEYS = Options.key((String)"primary_keys").listType().noDefaultValue().withDescription("primary keys");
    public static final Option<Boolean> SUPPORT_UPSERT_BY_QUERY_PRIMARY_KEY_EXIST = Options.key((String)"support_upsert_by_query_primary_key_exist").booleanType().defaultValue((Object)false).withDescription("support upsert by query primary_key exist");
    public static final Option<Boolean> ENABLE_UPSERT = Options.key((String)"enable_upsert").booleanType().defaultValue((Object)true).withDescription("enable upsert by primary_keys exist");
    public static final Option<Boolean> IS_PRIMARY_KEY_UPDATED = Options.key((String)"is_primary_key_updated").booleanType().defaultValue((Object)true).withDescription("is the primary key updated when performing an update operation");
    public static final Option<Boolean> SUPPORT_UPSERT_BY_INSERT_ONLY = Options.key((String)"support_upsert_by_insert_only").booleanType().defaultValue((Object)false).withDescription("support upsert by insert only");
    public static final Option<Boolean> USE_COPY_STATEMENT = Options.key((String)"use_copy_statement").booleanType().defaultValue((Object)false).withDescription("support copy in statement (postgresql)");
    public static final Option<String> DIALECT = Options.key((String)"dialect").stringType().noDefaultValue().withDescription("The appointed dialect, if it does not exist, is still obtained according to the url");
    public static final Option<String> PARTITION_COLUMN = Options.key((String)"partition_column").stringType().noDefaultValue().withDescription("partition column");
    public static final Option<String> PARTITION_UPPER_BOUND = Options.key((String)"partition_upper_bound").stringType().noDefaultValue().withDescription("partition upper bound");
    public static final Option<String> PARTITION_LOWER_BOUND = Options.key((String)"partition_lower_bound").stringType().noDefaultValue().withDescription("partition lower bound");
    public static final Option<Integer> PARTITION_NUM = Options.key((String)"partition_num").intType().noDefaultValue().withDescription("partition num");
    public static final Option<FieldIdeEnum> FIELD_IDE = Options.key((String)"field_ide").enumType(FieldIdeEnum.class).noDefaultValue().withDescription("Whether case conversion is required");
    public static final Option<Boolean> USE_KERBEROS = Options.key((String)"use_kerberos").booleanType().defaultValue((Object)false).withDescription("Whether to enable Kerberos, default is false.");
    public static final Option<String> KERBEROS_PRINCIPAL = Options.key((String)"kerberos_principal").stringType().noDefaultValue().withDescription("When use kerberos, we should set kerberos principal such as 'test_user@xxx'. ");
    public static final Option<String> KERBEROS_KEYTAB_PATH = Options.key((String)"kerberos_keytab_path").stringType().noDefaultValue().withDescription("When use kerberos, we should set kerberos principal file path such as '/home/test/test_user.keytab'. ");
    public static final Option<String> KRB5_PATH = Options.key((String)"krb5_path").stringType().defaultValue((Object)"/etc/krb5.conf").withDescription("When use kerberos, we should set krb5 path file path such as '/seatunnel/krb5.conf' or use the default path '/etc/krb5.conf");
    public static final Option<Map<String, String>> PROPERTIES = Options.key((String)"properties").mapType().noDefaultValue().withDescription("additional connection configuration parameters");
    public static final Option<StringSplitMode> STRING_SPLIT_MODE = Options.key((String)"split.string_split_mode").enumType(StringSplitMode.class).defaultValue((Object)StringSplitMode.SAMPLE).withDescription("Supports different string splitting algorithms. By default, `sample` is used to determine the split by sampling the string value. You can switch to `charset_based` to enable charset-based string splitting algorithm. When set to `charset_based`, the algorithm assumes characters of partition_column are within ASCII range 32-126, which covers most character-based splitting scenarios.");
    public static final Option<String> STRING_SPLIT_MODE_COLLATE = Options.key((String)"split.string_split_mode_collate").stringType().noDefaultValue().withDescription("Specifies the collation to use when string_split_mode is set to `charset_based` and the table has a special collation. If not specified, the database's default collation will be used.");
}

