/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.shade.io.grpc.netty;

import io.perfmark.Link;
import io.perfmark.PerfMark;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.tikv.common.util.HistogramUtils;
import org.tikv.shade.com.google.common.annotations.VisibleForTesting;
import org.tikv.shade.com.google.common.base.Preconditions;
import org.tikv.shade.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.tikv.shade.io.netty.channel.Channel;
import org.tikv.shade.io.netty.channel.ChannelFuture;
import org.tikv.shade.io.netty.channel.ChannelPromise;
import org.tikv.shade.io.prometheus.client.Histogram;

class WriteQueue {
    @VisibleForTesting
    static final int DEQUE_CHUNK_SIZE = 128;
    private final Runnable later = new Runnable(){

        @Override
        public void run() {
            WriteQueue.this.flush();
        }
    };
    private final Channel channel;
    private final Queue<Pair<QueuedCommand, Long>> queue;
    private final AtomicBoolean scheduled = new AtomicBoolean();
    public static final Histogram writeQueuePendingDuration = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("grpc_netty_write_queue_pending_duration_ms")).labelNames("type")).help("Pending duration of a task in the write queue.")).register();
    public static final Histogram writeQueueWaitBatchDuration = (Histogram)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("grpc_netty_write_queue_wait_batch_duration_seconds")).help("Duration of waiting a batch filled in the write queue.")).register();
    public static final Histogram writeQueueBatchSize = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().exponentialBuckets(1.0, 2.0, 10).name("grpc_netty_write_queue_batch_size")).help("Number of tasks in a batch in the write queue.")).register();
    public static final Histogram writeQueueCmdRunDuration = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("grpc_netty_write_queue_cmd_run_duration_seconds")).help("Duration of a task execution in the write queue.")).labelNames("type")).register();
    public static final Histogram writeQueueChannelFlushDuration = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("grpc_netty_write_queue_channel_flush_duration_seconds")).help("Duration of a channel flush in the write queue.")).labelNames("phase")).register();
    public static final Histogram writeQueueFlushDuration = (Histogram)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("grpc_netty_write_queue_flush_duration_seconds")).help("Duration of a flush of the write queue.")).register();
    public static final Histogram perfmarkWriteQueueDuration = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("perfmark_write_queue_duration_seconds")).help("Perfmark write queue duration seconds")).labelNames("type")).register();

    public WriteQueue(Channel channel) {
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.queue = new ConcurrentLinkedQueue<Pair<QueuedCommand, Long>>();
    }

    void scheduleFlush() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.channel.eventLoop().execute(this.later);
        }
    }

    @CanIgnoreReturnValue
    ChannelFuture enqueue(QueuedCommand command, boolean flush) {
        Preconditions.checkArgument(command.promise() == null, "promise must not be set on command");
        ChannelPromise promise = this.channel.newPromise();
        command.promise(promise);
        this.queue.add(Pair.of(command, System.nanoTime()));
        if (flush) {
            this.scheduleFlush();
        }
        return promise;
    }

    void enqueue(Runnable runnable, boolean flush) {
        Long now = System.nanoTime();
        this.queue.add(Pair.of(new RunnableCommand(runnable), now));
        if (flush) {
            this.scheduleFlush();
        }
    }

    void drainNow() {
        Preconditions.checkState(this.channel.eventLoop().inEventLoop(), "must be on the event loop");
        if (this.queue.peek() == null) {
            return;
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        block12: {
            Histogram.Timer flushTimer = writeQueueFlushDuration.startTimer();
            PerfMark.startTask("WriteQueue.periodicFlush");
            Histogram.Timer periodicFlush = ((Histogram.Child)perfmarkWriteQueueDuration.labels("WriteQueue.periodicFlush")).startTimer();
            long start = System.nanoTime();
            try {
                Pair<QueuedCommand, Long> item;
                int i = 0;
                boolean flushedOnce = false;
                Histogram.Timer waitBatchTimer = writeQueueWaitBatchDuration.startTimer();
                while ((item = this.queue.poll()) != null) {
                    QueuedCommand cmd = item.getLeft();
                    String cmdName = cmd.getClass().getSimpleName();
                    ((Histogram.Child)writeQueuePendingDuration.labels(cmdName)).observe((double)(System.nanoTime() - item.getRight()) / 1000000.0);
                    Histogram.Timer cmdTimer = ((Histogram.Child)writeQueueCmdRunDuration.labels(cmdName)).startTimer();
                    cmd.run(this.channel);
                    cmdTimer.observeDuration();
                    if (++i != 128) continue;
                    waitBatchTimer.observeDuration();
                    i = 0;
                    PerfMark.startTask("WriteQueue.flush0");
                    Histogram.Timer flush0 = ((Histogram.Child)perfmarkWriteQueueDuration.labels("WriteQueue.flush0")).startTimer();
                    Histogram.Timer channelFlushTimer = ((Histogram.Child)writeQueueChannelFlushDuration.labels("flush0")).startTimer();
                    try {
                        this.channel.flush();
                    }
                    finally {
                        waitBatchTimer = writeQueueWaitBatchDuration.startTimer();
                        writeQueueBatchSize.observe(128.0);
                        channelFlushTimer.observeDuration();
                        PerfMark.stopTask("WriteQueue.flush0");
                        flush0.observeDuration();
                    }
                    flushedOnce = true;
                }
                if (i == 0 && flushedOnce) break block12;
                waitBatchTimer.observeDuration();
                PerfMark.startTask("WriteQueue.flush1");
                Histogram.Timer flush1 = ((Histogram.Child)perfmarkWriteQueueDuration.labels("WriteQueue.flush1")).startTimer();
                Histogram.Timer channelFlushTimer = ((Histogram.Child)writeQueueChannelFlushDuration.labels("flush1")).startTimer();
                try {
                    this.channel.flush();
                }
                finally {
                    writeQueueBatchSize.observe(i);
                    channelFlushTimer.observeDuration();
                    PerfMark.stopTask("WriteQueue.flush1");
                    flush1.observeDuration();
                }
            }
            finally {
                PerfMark.stopTask("WriteQueue.periodicFlush");
                periodicFlush.observeDuration();
                flushTimer.observeDuration();
                this.scheduled.set(false);
                if (!this.queue.isEmpty()) {
                    this.scheduleFlush();
                }
            }
        }
    }

    static interface QueuedCommand {
        public ChannelPromise promise();

        public void promise(ChannelPromise var1);

        public void run(Channel var1);

        public Link getLink();
    }

    static abstract class AbstractQueuedCommand
    implements QueuedCommand {
        private ChannelPromise promise;
        private final Link link = PerfMark.linkOut();

        AbstractQueuedCommand() {
        }

        @Override
        public final void promise(ChannelPromise promise) {
            this.promise = promise;
        }

        @Override
        public final ChannelPromise promise() {
            return this.promise;
        }

        @Override
        public final void run(Channel channel) {
            channel.write(this, this.promise);
        }

        @Override
        public Link getLink() {
            return this.link;
        }
    }

    private static class RunnableCommand
    implements QueuedCommand {
        private final Runnable runnable;
        private final Link link = PerfMark.linkOut();

        public RunnableCommand(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public final void promise(ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ChannelPromise promise() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void run(Channel channel) {
            this.runnable.run();
        }

        @Override
        public Link getLink() {
            return this.link;
        }
    }
}

