/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect;

import java.util.Optional;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.AbstractJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.GenericTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDialect
implements JdbcDialect {
    private static final Logger log = LoggerFactory.getLogger(GenericDialect.class);
    public String fieldIde = FieldIdeEnum.ORIGINAL.getValue();

    public GenericDialect() {
    }

    public GenericDialect(String fieldIde) {
        this.fieldIde = fieldIde;
    }

    @Override
    public String dialectName() {
        return "Generic";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new AbstractJdbcRowConverter(){

            @Override
            public String converterName() {
                return "Generic";
            }
        };
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new GenericTypeMapper();
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return this.getFieldIde(identifier, this.fieldIde);
    }

    @Override
    public String quoteDatabaseIdentifier(String identifier) {
        return identifier;
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return this.tableIdentifier(tablePath.getDatabaseName(), tablePath.getTableName());
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)false);
    }
}

