/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.highgo;

import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.OptionValidationException;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.highgo.HighGoCatalog;

public class HighGoCatalogFactory
implements CatalogFactory {
    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        String urlWithDatabase = (String)options.get(JdbcCatalogOptions.BASE_URL);
        JdbcUrlUtil.UrlInfo urlInfo = JdbcUrlUtil.getUrlInfo((String)urlWithDatabase);
        Optional defaultDatabase = urlInfo.getDefaultDatabase();
        if (!defaultDatabase.isPresent()) {
            throw new OptionValidationException(JdbcCatalogOptions.BASE_URL);
        }
        return new HighGoCatalog(catalogName, (String)options.get(JdbcCatalogOptions.USERNAME), (String)options.get(JdbcCatalogOptions.PASSWORD), urlInfo, (String)options.get(JdbcCatalogOptions.SCHEMA));
    }

    public String factoryIdentifier() {
        return "Highgo";
    }

    public OptionRule optionRule() {
        return JdbcCatalogOptions.BASE_RULE.build();
    }
}

