/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.exception.MongodbConnectorException;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;

public class ResumeToken {
    private static final int K_TIMESTAMP = 130;

    public static BsonTimestamp decodeTimestamp(BsonDocument resumeToken) {
        byte[] keyStringBytes;
        BsonValue bsonValue = Objects.requireNonNull(resumeToken, "Missing ResumeToken.").get("_data");
        if (bsonValue.isBinary()) {
            keyStringBytes = bsonValue.asBinary().getData();
        } else if (bsonValue.isString()) {
            keyStringBytes = ResumeToken.hexToUint8Array(bsonValue.asString().getValue());
        } else {
            throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Unknown resume token format: " + bsonValue);
        }
        ByteBuffer buffer = ByteBuffer.wrap(keyStringBytes).order(ByteOrder.BIG_ENDIAN);
        int kType = buffer.get() & 0xFF;
        if (kType != 130) {
            throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Unknown keyType of timestamp: " + kType);
        }
        int t = buffer.getInt();
        int i = buffer.getInt();
        return new BsonTimestamp(t, i);
    }

    private static byte[] hexToUint8Array(@Nonnull String str) {
        int len = str.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        return data;
    }
}

