/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters;

import com.mongodb.MongoQueryException;
import com.mongodb.client.MongoClient;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.cdc.base.source.split.SnapshotSplit;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SampleBucketSplitStrategy;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SplitContext;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SplitStrategy;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils.MongodbUtils;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedSplitStrategy
implements SplitStrategy {
    private static final Logger log = LoggerFactory.getLogger(ShardedSplitStrategy.class);
    public static final ShardedSplitStrategy INSTANCE = new ShardedSplitStrategy();

    private ShardedSplitStrategy() {
    }

    @Override
    public Collection<SnapshotSplit> split(@Nonnull SplitContext splitContext) {
        List<BsonDocument> chunks;
        BsonDocument collectionMetadata;
        TableId collectionId = splitContext.getCollectionId();
        MongoClient mongoClient = splitContext.getMongoClient();
        try {
            collectionMetadata = MongodbUtils.readCollectionMetadata(mongoClient, collectionId);
            if (!this.isValidShardedCollection(collectionMetadata)) {
                log.warn("Collection {} does not appear to be sharded, fallback to SampleSplitter.", (Object)collectionId);
                return SampleBucketSplitStrategy.INSTANCE.split(splitContext);
            }
            chunks = MongodbUtils.readChunks(mongoClient, collectionMetadata);
        }
        catch (MongoQueryException e) {
            if (e.getErrorCode() == 13) {
                log.warn("Unauthorized to read config.collections or config.chunks: {}, fallback to SampleSplitter.", (Object)e.getErrorMessage());
            } else {
                log.warn("Read config.chunks collection failed: {}, fallback to SampleSplitter", (Object)e.getErrorMessage());
            }
            return SampleBucketSplitStrategy.INSTANCE.split(splitContext);
        }
        if (chunks.isEmpty()) {
            log.warn("Collection {} does not appear to be sharded, fallback to SampleSplitter.", (Object)collectionId);
            return SampleBucketSplitStrategy.INSTANCE.split(splitContext);
        }
        BsonDocument splitKeys = collectionMetadata.getDocument("key");
        SeaTunnelRowType rowType = this.shardKeysToRowType(splitKeys);
        ArrayList<SnapshotSplit> snapshotSplits = new ArrayList<SnapshotSplit>(chunks.size());
        for (int i = 0; i < chunks.size(); ++i) {
            BsonDocument chunk = chunks.get(i);
            snapshotSplits.add(new SnapshotSplit(this.splitId(collectionId, i), collectionId, rowType, new Object[]{splitKeys, chunk.getDocument("min")}, new Object[]{splitKeys, chunk.getDocument("max")}));
        }
        return snapshotSplits;
    }

    private boolean isValidShardedCollection(BsonDocument collectionMetadata) {
        return collectionMetadata != null && !collectionMetadata.getBoolean("dropped", BsonBoolean.FALSE).getValue();
    }
}

