/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.schema;

import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public final class SchemaDebugHelper {
    public static String prettyPrintSchema(String name, Schema schema) {
        return SchemaDebugHelper.appendSchemaInformation(new StringBuilder(), name, schema).toString();
    }

    static String prettyPrintSchemas(Schema firstSchema, Schema secondSchema) {
        StringBuilder builder = new StringBuilder();
        builder.append(firstSchema.type());
        builder.append(" : ");
        builder.append(secondSchema.type());
        if (firstSchema.type().isPrimitive() && secondSchema.type().isPrimitive()) {
            return builder.toString();
        }
        builder.append("\n");
        SchemaDebugHelper.appendSchemaInformation(builder, "Schema one", firstSchema);
        SchemaDebugHelper.appendSchemaInformation(builder, "Schema two", secondSchema);
        return builder.toString();
    }

    public static StringBuilder appendSchemaInformation(StringBuilder builder, String name, Schema schema) {
        builder.append(name);
        builder.append(":\n");
        SchemaDebugHelper.appendSchemaInformation(builder, schema, 0);
        return builder;
    }

    private static void appendSchemaInformation(StringBuilder builder, Schema schema, int level) {
        String padding = SchemaDebugHelper.createPadding(level);
        if (level > 10) {
            builder.append(padding);
            builder.append(" ... Very high level of nesting ...");
            return;
        }
        switch (schema.type()) {
            case ARRAY: {
                builder.append(padding);
                StringBuilder arrayPostfix = new StringBuilder();
                builder.append(" [");
                arrayPostfix.append(" ]");
                Schema valueSchema = schema.valueSchema();
                while (valueSchema.type() == Schema.Type.ARRAY) {
                    builder.append(" [");
                    arrayPostfix.append(" ]");
                    valueSchema = valueSchema.valueSchema();
                }
                builder.append("\n");
                SchemaDebugHelper.appendSchemaInformation(builder, valueSchema, level);
                builder.append(padding);
                builder.append((CharSequence)arrayPostfix);
                builder.append("\n");
                break;
            }
            case STRUCT: {
                schema.fields().forEach(f -> SchemaDebugHelper.appendFieldInformation(builder, f, level + 1));
                break;
            }
            default: {
                builder.append(padding);
                builder.append(schema.type().getName());
                builder.append("\n");
            }
        }
    }

    private static void appendFieldInformation(StringBuilder builder, Field field, int level) {
        String padding = SchemaDebugHelper.createPadding(level);
        builder.append(padding);
        builder.append(field.name());
        builder.append(": ");
        builder.append(field.schema().type().getName());
        builder.append(" (optional = ");
        builder.append(field.schema().isOptional());
        builder.append(")");
        builder.append(" (name = ");
        builder.append(field.schema().name());
        builder.append(")");
        builder.append("\n");
        switch (field.schema().type()) {
            case ARRAY: 
            case STRUCT: {
                SchemaDebugHelper.appendSchemaInformation(builder, field.schema(), level);
                break;
            }
        }
    }

    private static String createPadding(int level) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ");
        for (int i = 1; i <= level; ++i) {
            stringBuilder.append(" | ");
        }
        return stringBuilder.toString();
    }

    private SchemaDebugHelper() {
    }
}

