/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.schema;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;

public final class AvroSchema {
    public static Schema validateJsonSchema(String jsonSchema) {
        Schema avroSchema = AvroSchema.parseSchema(jsonSchema);
        if (avroSchema.getType() != Schema.Type.RECORD) {
            throw new ConnectException("Only Record schemas are supported at the top-level.");
        }
        AvroSchema.validateAvroSchema(avroSchema, "", new ArrayList<String>());
        return avroSchema;
    }

    private static void validateAvroSchema(Schema avroSchema, String fieldPath, List<String> recordList) {
        switch (avroSchema.getType()) {
            case RECORD: {
                if (recordList.contains(avroSchema.getFullName())) break;
                recordList.add(avroSchema.getFullName());
                avroSchema.getFields().forEach(f -> {
                    String newFieldPath = fieldPath.isEmpty() ? f.name() : String.format("%s.%s", fieldPath, f.name());
                    AvroSchema.validateAvroSchema(f.schema(), newFieldPath, recordList);
                });
                break;
            }
            case ARRAY: {
                AvroSchema.validateAvroSchema(avroSchema.getElementType(), fieldPath, recordList);
                break;
            }
            case MAP: {
                AvroSchema.validateAvroSchema(avroSchema.getValueType(), fieldPath, recordList);
                break;
            }
            case UNION: {
                if (avroSchema.getTypes().size() != 2 || avroSchema.getTypes().stream().noneMatch(s -> s.getType() == Schema.Type.NULL)) {
                    throw AvroSchema.createConnectException("Union Schemas are not supported, unless one value is null to represent an optional value.", fieldPath);
                }
                avroSchema.getTypes().stream().filter(s -> s.getType() != Schema.Type.NULL).forEach(schema -> {
                    try {
                        AvroSchema.validateAvroSchema(schema, "", recordList);
                    }
                    catch (ConnectException e) {
                        String lowercaseErrorMessage = e.getMessage().substring(0, 1).toLowerCase() + e.getMessage().substring(1);
                        switch (schema.getType()) {
                            case RECORD: 
                            case ARRAY: 
                            case MAP: 
                            case UNION: {
                                throw AvroSchema.createConnectException(String.format("Union Schema contains an unsupported Avro schema type: '%s', which contains an %s", new Object[]{schema.getType(), lowercaseErrorMessage}), fieldPath);
                            }
                        }
                        throw AvroSchema.createConnectException(String.format("Union Schema contains an %s", lowercaseErrorMessage), fieldPath);
                    }
                });
                break;
            }
            case FIXED: {
                throw AvroSchema.createConnectException(String.format("Unsupported Avro schema type: '%s'. The connector will not validate the length. Use bytes instead.", new Object[]{avroSchema.getType()}), fieldPath);
            }
            case ENUM: {
                throw AvroSchema.createConnectException(String.format("Unsupported Avro schema type: '%s'. The connector will not validate the values. Use string instead.", new Object[]{avroSchema.getType()}), fieldPath);
            }
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return;
            }
            default: {
                throw AvroSchema.createConnectException(String.format("Unsupported Avro schema type: '%s'.", new Object[]{avroSchema.getType()}), fieldPath);
            }
        }
    }

    public static org.apache.kafka.connect.data.Schema fromJson(String jsonSchema) {
        Schema parsedSchema = AvroSchema.validateJsonSchema(jsonSchema);
        return AvroSchema.createSchema(parsedSchema, false, null, new Context());
    }

    static Schema parseSchema(String jsonSchema) {
        try {
            return new Schema.Parser().setValidate(false).parse(jsonSchema);
        }
        catch (Exception e) {
            throw new ConnectException(String.format("Invalid Avro schema. %s\n%s", e.getMessage(), jsonSchema));
        }
    }

    private static org.apache.kafka.connect.data.Schema createSchema(Schema avroSchema, boolean isOptional, Object defaultValue, Context context) {
        SchemaBuilder builder;
        switch (avroSchema.getType()) {
            case RECORD: {
                SchemaBuilder structBuilder = SchemaBuilder.struct();
                context.schemaCache.put(avroSchema, structBuilder);
                structBuilder.name(avroSchema.getFullName());
                avroSchema.getFields().forEach(f -> {
                    if (context.schemaCache.containsKey(f.schema())) {
                        context.detectedCycles.add(f.schema());
                        structBuilder.field(f.name(), (org.apache.kafka.connect.data.Schema)context.schemaCache.get(f.schema()));
                    } else {
                        org.apache.kafka.connect.data.Schema fieldSchema = AvroSchema.createSchema(f.schema(), false, f.defaultVal(), context);
                        structBuilder.field(f.name(), fieldSchema);
                    }
                });
                builder = structBuilder;
                break;
            }
            case MAP: {
                builder = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)AvroSchema.createSchemaCheckCycles(avroSchema.getValueType(), defaultValue, context));
                break;
            }
            case ARRAY: {
                builder = SchemaBuilder.array((org.apache.kafka.connect.data.Schema)AvroSchema.createSchemaCheckCycles(avroSchema.getElementType(), defaultValue, context));
                break;
            }
            case STRING: {
                builder = SchemaBuilder.string();
                break;
            }
            case BYTES: {
                builder = SchemaBuilder.bytes();
                break;
            }
            case INT: {
                builder = SchemaBuilder.int32();
                break;
            }
            case LONG: {
                builder = SchemaBuilder.int64();
                break;
            }
            case FLOAT: {
                builder = SchemaBuilder.float32();
                break;
            }
            case DOUBLE: {
                builder = SchemaBuilder.float64();
                break;
            }
            case BOOLEAN: {
                builder = SchemaBuilder.bool();
                break;
            }
            case UNION: {
                Optional<Schema> optionalSchema = avroSchema.getTypes().stream().filter(s -> s.getType() != Schema.Type.NULL).findFirst();
                if (optionalSchema.isPresent()) {
                    return AvroSchema.createSchema(optionalSchema.get(), true, null, context);
                }
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (isOptional) {
            builder.optional();
        }
        if (defaultValue != null) {
            builder.defaultValue(AvroSchema.processDefaultValue(builder, defaultValue));
        }
        if (!context.detectedCycles.contains(avroSchema)) {
            context.schemaCache.remove(avroSchema);
        }
        return builder.build();
    }

    static Object processDefaultValue(SchemaBuilder schemaBuilder, Object value) {
        if (schemaBuilder.type() == Schema.Type.STRUCT) {
            Struct structValue = new Struct((org.apache.kafka.connect.data.Schema)schemaBuilder);
            if (value instanceof Map) {
                Map defaultMap = (Map)value;
                structValue.schema().fields().forEach(f -> {
                    if (defaultMap.containsKey(f.name())) {
                        structValue.put(f, defaultMap.get(f.name()));
                    }
                });
            }
            return structValue;
        }
        return value;
    }

    private static org.apache.kafka.connect.data.Schema createSchemaCheckCycles(Schema avroSchema, Object defaultValue, Context context) {
        org.apache.kafka.connect.data.Schema resolvedSchema;
        if (context.schemaCache.containsKey(avroSchema)) {
            context.detectedCycles.add(avroSchema);
            resolvedSchema = ((org.apache.kafka.connect.data.Schema)context.schemaCache.get(avroSchema)).schema();
        } else {
            resolvedSchema = AvroSchema.createSchema(avroSchema, false, defaultValue, context);
        }
        return resolvedSchema;
    }

    private static ConnectException createConnectException(String message, String fieldPath) {
        String errorMessage = message;
        if (!fieldPath.isEmpty()) {
            errorMessage = String.format("Field '%s' is invalid. %s", fieldPath, message);
        }
        return new ConnectException(errorMessage);
    }

    private AvroSchema() {
    }

    private static final class Context {
        private final Map<Schema, org.apache.kafka.connect.data.Schema> schemaCache = new IdentityHashMap<Schema, org.apache.kafka.connect.data.Schema>();
        private final Set<Schema> detectedCycles = new HashSet<Schema>();

        private Context() {
        }
    }
}

