/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.debezium.rdbms;

import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.cdc.debezium.DebeziumCdcHandler;
import com.mongodb.kafka.connect.sink.cdc.debezium.OperationType;
import com.mongodb.kafka.connect.sink.cdc.debezium.rdbms.RdbmsDelete;
import com.mongodb.kafka.connect.sink.cdc.debezium.rdbms.RdbmsInsert;
import com.mongodb.kafka.connect.sink.cdc.debezium.rdbms.RdbmsUpdate;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbmsHandler
extends DebeziumCdcHandler {
    private static final String ID_FIELD = "_id";
    private static final String JSON_DOC_BEFORE_FIELD = "before";
    private static final String JSON_DOC_AFTER_FIELD = "after";
    private static final Logger LOGGER = LoggerFactory.getLogger(RdbmsHandler.class);
    private static final Map<OperationType, CdcOperation> DEFAULT_OPERATIONS = new HashMap<OperationType, CdcOperation>(){
        {
            this.put(OperationType.CREATE, new RdbmsInsert());
            this.put(OperationType.READ, new RdbmsInsert());
            this.put(OperationType.UPDATE, new RdbmsUpdate());
            this.put(OperationType.DELETE, new RdbmsDelete());
        }
    };

    public RdbmsHandler(MongoSinkTopicConfig config) {
        this(config, DEFAULT_OPERATIONS);
    }

    public RdbmsHandler(MongoSinkTopicConfig config, Map<OperationType, CdcOperation> operations) {
        super(config);
        this.registerOperations(operations);
    }

    @Override
    public Optional<WriteModel<BsonDocument>> handle(SinkDocument doc) {
        BsonDocument keyDoc = doc.getKeyDoc().orElseGet(BsonDocument::new);
        BsonDocument valueDoc = doc.getValueDoc().orElseGet(BsonDocument::new);
        if (valueDoc.isEmpty()) {
            LOGGER.debug("Skipping debezium tombstone event for kafka topic compaction");
            return Optional.empty();
        }
        return Optional.of(this.getCdcOperation(valueDoc).perform(new SinkDocument(keyDoc, valueDoc)));
    }

    static BsonDocument generateFilterDoc(BsonDocument keyDoc, BsonDocument valueDoc, OperationType opType) {
        if (keyDoc.keySet().isEmpty()) {
            if (opType.equals((Object)OperationType.CREATE) || opType.equals((Object)OperationType.READ)) {
                return new BsonDocument(ID_FIELD, new BsonObjectId());
            }
            try {
                BsonDocument filter = valueDoc.getDocument(JSON_DOC_BEFORE_FIELD);
                if (filter.isEmpty()) {
                    throw new BsonInvalidOperationException("value doc before field is empty");
                }
                return filter;
            }
            catch (BsonInvalidOperationException exc) {
                throw new DataException("Value doc 'before' field is empty or has invalid type for update/delete operation.  -> defensive actions taken!", (Throwable)exc);
            }
        }
        BsonDocument pk = new BsonDocument();
        for (String f : keyDoc.keySet()) {
            pk.put(f, keyDoc.get(f));
        }
        return new BsonDocument(ID_FIELD, pk);
    }

    static BsonDocument generateUpsertOrReplaceDoc(BsonDocument keyDoc, BsonDocument valueDoc, BsonDocument filterDoc) {
        if (!valueDoc.containsKey(JSON_DOC_AFTER_FIELD) || valueDoc.get(JSON_DOC_AFTER_FIELD).isNull() || !valueDoc.get(JSON_DOC_AFTER_FIELD).isDocument() || valueDoc.getDocument(JSON_DOC_AFTER_FIELD).isEmpty()) {
            throw new DataException("Value document must contain non-empty 'after' field of type document for insert/update operation");
        }
        BsonDocument upsertDoc = new BsonDocument();
        if (filterDoc.containsKey(ID_FIELD)) {
            upsertDoc.put(ID_FIELD, filterDoc.get(ID_FIELD));
        }
        BsonDocument afterDoc = valueDoc.getDocument(JSON_DOC_AFTER_FIELD);
        for (String f : afterDoc.keySet()) {
            if (keyDoc.containsKey(f)) continue;
            upsertDoc.put(f, afterDoc.get(f));
        }
        return upsertDoc;
    }
}

