/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.debezium.mongodb;

import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;

public class MongoDbInsert
implements CdcOperation {
    private static final ReplaceOptions REPLACE_OPTIONS = new ReplaceOptions().upsert(true);
    private static final String JSON_DOC_FIELD_PATH = "after";

    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        BsonDocument valueDoc = doc.getValueDoc().orElseThrow(() -> new DataException("Value document must not be missing for insert operation"));
        if (!valueDoc.containsKey(JSON_DOC_FIELD_PATH)) {
            throw new DataException(String.format("Insert document missing `%s` field.", JSON_DOC_FIELD_PATH));
        }
        try {
            BsonDocument insertDoc = BsonDocument.parse(valueDoc.get(JSON_DOC_FIELD_PATH).asString().getValue());
            return new ReplaceOneModel<BsonDocument>(new BsonDocument("_id", insertDoc.get("_id")), insertDoc, REPLACE_OPTIONS);
        }
        catch (Exception exc) {
            throw new DataException(exc);
        }
    }
}

