/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.schema;

import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnsEvent;
import org.apache.seatunnel.api.table.schema.event.SchemaChangeEvent;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.schema.SchemaChangeResolver;
import org.apache.seatunnel.connectors.cdc.base.utils.SourceRecordUtils;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaChangeResolver
implements SchemaChangeResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaChangeResolver.class);
    protected static final List<String> SUPPORT_DDL = Lists.newArrayList((Object[])new String[]{"ALTER TABLE"});
    protected final JdbcSourceConfig jdbcSourceConfig;
    protected transient DdlParser ddlParser;
    protected transient Tables tables;
    protected String sourceDialectName;

    public AbstractSchemaChangeResolver(JdbcSourceConfig jdbcSourceConfig) {
        this.jdbcSourceConfig = jdbcSourceConfig;
    }

    @Override
    public boolean support(SourceRecord record) {
        String ddl = SourceRecordUtils.getDdl(record);
        Struct value = (Struct)record.value();
        List tableChanges = value.getArray("tableChanges");
        if (tableChanges == null || tableChanges.isEmpty()) {
            log.warn("Ignoring statement for non-captured table {}", (Object)ddl);
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)ddl) && SUPPORT_DDL.stream().map(String::toUpperCase).anyMatch(prefix -> ddl.toUpperCase().contains((CharSequence)prefix));
    }

    @Override
    public SchemaChangeEvent resolve(SourceRecord record, List<CatalogTable> catalogTables) {
        TablePath tablePath = SourceRecordUtils.getTablePath(record);
        String ddl = SourceRecordUtils.getDdl(record);
        if (Objects.isNull(this.ddlParser)) {
            this.ddlParser = this.createDdlParser(tablePath);
        }
        if (Objects.isNull(this.tables)) {
            this.tables = new Tables();
        }
        this.ddlParser.setCurrentDatabase(tablePath.getDatabaseName());
        this.ddlParser.setCurrentSchema(tablePath.getSchemaName());
        this.ddlParser.parse(ddl, this.tables);
        List<AlterTableColumnEvent> parsedEvents = this.getAndClearParsedEvents();
        parsedEvents = this.completionEvent(parsedEvents, catalogTables);
        parsedEvents.forEach(e -> e.setSourceDialectName(this.getSourceDialectName()));
        AlterTableColumnsEvent alterTableColumnsEvent = new AlterTableColumnsEvent(TableIdentifier.of((String)"", (String)tablePath.getDatabaseName(), (String)tablePath.getSchemaName(), (String)tablePath.getTableName()), parsedEvents);
        alterTableColumnsEvent.setStatement(ddl);
        alterTableColumnsEvent.setSourceDialectName(this.getSourceDialectName());
        return parsedEvents.isEmpty() ? null : alterTableColumnsEvent;
    }

    List<AlterTableColumnEvent> completionEvent(List<AlterTableColumnEvent> events, List<CatalogTable> catalogTables) {
        return events.stream().map(columnEvent -> {
            columnEvent.setSourceDialectName(this.getSourceDialectName());
            if (catalogTables == null || catalogTables.isEmpty()) {
                return columnEvent;
            }
            if (!(columnEvent instanceof AlterTableChangeColumnEvent)) {
                return columnEvent;
            }
            AlterTableChangeColumnEvent changeColumnEvent = (AlterTableChangeColumnEvent)columnEvent;
            if (changeColumnEvent.getColumn().getDataType() != null) {
                return columnEvent;
            }
            CatalogTable table = catalogTables.stream().filter(catalogTable -> catalogTable.getTablePath().equals((Object)columnEvent.getTablePath())).findFirst().orElse(null);
            if (table != null) {
                Column oldColumn = table.getTableSchema().getColumn(changeColumnEvent.getOldColumn());
                Column newColumn = oldColumn.rename(changeColumnEvent.getColumn().getName());
                AlterTableChangeColumnEvent newEvent = new AlterTableChangeColumnEvent(changeColumnEvent.getTableIdentifier(), changeColumnEvent.getOldColumn(), newColumn, changeColumnEvent.isFirst(), changeColumnEvent.getAfterColumn());
                newEvent.setSourceDialectName(this.getSourceDialectName());
                return newEvent;
            }
            log.warn("Ignoring rename column {} type completion for table {}", (Object)changeColumnEvent.getOldColumn(), (Object)changeColumnEvent.getTablePath());
            return columnEvent;
        }).collect(Collectors.toList());
    }

    protected abstract DdlParser createDdlParser(TablePath var1);

    protected abstract List<AlterTableColumnEvent> getAndClearParsedEvents();

    protected abstract String getSourceDialectName();

    public void setDdlParser(DdlParser ddlParser) {
        this.ddlParser = ddlParser;
    }

    public void setTables(Tables tables) {
        this.tables = tables;
    }

    public void setSourceDialectName(String sourceDialectName) {
        this.sourceDialectName = sourceDialectName;
    }
}

