/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.hotspot;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import io.prometheus.client.Collector;
import io.prometheus.client.Counter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class MemoryAllocationExports
extends Collector {
    private final Counter allocatedCounter = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("jvm_memory_pool_allocated_bytes_total")).help("Total bytes allocated in a given JVM memory pool. Only updated after GC, not continuously.")).labelNames("pool")).create();

    public MemoryAllocationExports() {
        AllocationCountingNotificationListener listener = new AllocationCountingNotificationListener(this.allocatedCounter);
        for (GarbageCollectorMXBean garbageCollectorMXBean : this.getGarbageCollectorMXBeans()) {
            if (!(garbageCollectorMXBean instanceof NotificationEmitter)) continue;
            ((NotificationEmitter)((Object)garbageCollectorMXBean)).addNotificationListener(listener, null, null);
        }
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        return this.allocatedCounter.collect();
    }

    protected List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementFactory.getGarbageCollectorMXBeans();
    }

    static class AllocationCountingNotificationListener
    implements NotificationListener {
        private final Map<String, Long> lastMemoryUsage = new HashMap<String, Long>();
        private final Counter counter;

        AllocationCountingNotificationListener(Counter counter) {
            this.counter = counter;
        }

        @Override
        public synchronized void handleNotification(Notification notification, Object handback) {
            GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
            GcInfo gcInfo = info.getGcInfo();
            Map<String, MemoryUsage> memoryUsageBeforeGc = gcInfo.getMemoryUsageBeforeGc();
            Map<String, MemoryUsage> memoryUsageAfterGc = gcInfo.getMemoryUsageAfterGc();
            for (Map.Entry<String, MemoryUsage> entry : memoryUsageBeforeGc.entrySet()) {
                String memoryPool = entry.getKey();
                long before = entry.getValue().getUsed();
                long after = memoryUsageAfterGc.get(memoryPool).getUsed();
                this.handleMemoryPool(memoryPool, before, after);
            }
        }

        void handleMemoryPool(String memoryPool, long before, long after) {
            long increase;
            long last = AllocationCountingNotificationListener.getAndSet(this.lastMemoryUsage, memoryPool, after);
            long diff1 = before - last;
            long diff2 = after - before;
            if (diff1 < 0L) {
                diff1 = 0L;
            }
            if (diff2 < 0L) {
                diff2 = 0L;
            }
            if ((increase = diff1 + diff2) > 0L) {
                ((Counter.Child)this.counter.labels(memoryPool)).inc(increase);
            }
        }

        private static long getAndSet(Map<String, Long> map, String key, long value) {
            Long last = map.put(key, value);
            return last == null ? 0L : last;
        }
    }
}

