/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.temporal;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@DefaultAnnotation(value={NonNull.class})
abstract class TemporalInstantRelationFunction
implements Function {
    TemporalInstantRelationFunction() {
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException(this.getURI() + " requires exactly 2 arguments, got " + args.length);
        }
        try {
            ZonedDateTime date1 = ZonedDateTime.parse(args[0].stringValue());
            ZonedDateTime date2 = ZonedDateTime.parse(args[1].stringValue());
            boolean result = this.relation(date1, date2);
            return valueFactory.createLiteral(result);
        }
        catch (DateTimeParseException e) {
            throw new ValueExprEvaluationException("Date/Times provided must be of the ISO-8601 format. Example: 2007-04-05T14:30Z");
        }
    }

    protected abstract boolean relation(ZonedDateTime var1, ZonedDateTime var2);
}

