/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.sp;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

@DefaultAnnotation(value={NonNull.class})
public class StatementPatternMatcher {
    private final StatementPattern pattern;

    public StatementPatternMatcher(StatementPattern pattern) {
        this.pattern = Objects.requireNonNull(pattern);
    }

    public Optional<BindingSet> match(Statement statement) {
        Objects.requireNonNull(statement);
        QueryBindingSet bs = new QueryBindingSet();
        if (this.matchesValue(this.pattern.getSubjectVar(), (Value)statement.getSubject(), bs) && this.matchesValue(this.pattern.getPredicateVar(), (Value)statement.getPredicate(), bs) && this.matchesValue(this.pattern.getObjectVar(), statement.getObject(), bs) && this.matchesContext(this.pattern.getContextVar(), (Value)statement.getContext(), bs)) {
            return Optional.of(bs);
        }
        return Optional.empty();
    }

    private boolean matchesValue(Var var, Value stmtValue, QueryBindingSet bs) {
        Objects.requireNonNull(var);
        Objects.requireNonNull(stmtValue);
        Objects.requireNonNull(bs);
        if (var.isConstant()) {
            if (!stmtValue.equals(var.getValue())) {
                return false;
            }
        } else {
            bs.addBinding(var.getName(), stmtValue);
        }
        return true;
    }

    private boolean matchesContext(@Nullable Var cntxVar, @Nullable Value stmtCntx, QueryBindingSet bs) {
        if (cntxVar == null) {
            return true;
        }
        if (stmtCntx == null) {
            return false;
        }
        return this.matchesValue(cntxVar, stmtCntx, bs);
    }
}

