/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.projection;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.rya.api.model.VisibilityBindingSet;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.impl.MapBindingSet;

@DefaultAnnotation(value={NonNull.class})
public class ProjectionEvaluator {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private final ProjectionElemList projectionElems;
    private final Map<String, Value> constantSources = new HashMap<String, Value>();
    private final Set<String> anonymousSources = new HashSet<String>();

    public ProjectionEvaluator(ProjectionElemList projectionElems, Optional<Extension> extensions) {
        this.projectionElems = Objects.requireNonNull(projectionElems);
        Objects.requireNonNull(extensions);
        if (extensions.isPresent()) {
            for (ExtensionElem extensionElem : extensions.get().getElements()) {
                String sourceName;
                ValueExpr valueExpr = extensionElem.getExpr();
                if (valueExpr instanceof ValueConstant) {
                    sourceName = extensionElem.getName();
                    Value targetValue = ((ValueConstant)valueExpr).getValue();
                    this.constantSources.put(sourceName, targetValue);
                    continue;
                }
                if (!(valueExpr instanceof BNodeGenerator)) continue;
                sourceName = extensionElem.getName();
                this.anonymousSources.add(sourceName);
            }
        }
    }

    public static ProjectionEvaluator make(Projection projection) {
        Objects.requireNonNull(projection);
        ProjectionElemList projectionElems = projection.getProjectionElemList();
        TupleExpr arg = projection.getArg();
        Optional<Extension> extension = arg instanceof Extension ? Optional.of((Extension)arg) : Optional.empty();
        return new ProjectionEvaluator(projectionElems, extension);
    }

    public VisibilityBindingSet project(VisibilityBindingSet bs) {
        return this.project(bs, new HashMap<String, BNode>());
    }

    public VisibilityBindingSet project(VisibilityBindingSet bs, Map<String, BNode> blankNodes) {
        Objects.requireNonNull(bs);
        Objects.requireNonNull(blankNodes);
        MapBindingSet result = new MapBindingSet();
        for (ProjectionElem elem : this.projectionElems.getElements()) {
            String sourceName = elem.getSourceName();
            Object value = null;
            if (bs.hasBinding(sourceName)) {
                value = bs.getValue(elem.getSourceName());
            } else if (this.constantSources.containsKey(sourceName)) {
                value = this.constantSources.get(sourceName);
            } else if (this.anonymousSources.contains(sourceName)) {
                value = blankNodes.containsKey(sourceName) ? (Value)blankNodes.get(sourceName) : VF.createBNode(UUID.randomUUID().toString());
            }
            if (value == null) continue;
            result.addBinding(elem.getTargetName(), value);
        }
        return new VisibilityBindingSet((BindingSet)result, bs.getVisibility());
    }
}

