/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.join;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.apache.rya.api.function.join.IterativeJoin;
import org.apache.rya.api.function.join.LazyJoiningIterator;
import org.apache.rya.api.model.VisibilityBindingSet;

@DefaultAnnotation(value={NonNull.class})
public final class LeftOuterJoin
implements IterativeJoin {
    @Override
    public Iterator<VisibilityBindingSet> newLeftResult(VisibilityBindingSet newLeftResult, Iterator<VisibilityBindingSet> rightResults) {
        Objects.requireNonNull(newLeftResult);
        Objects.requireNonNull(rightResults);
        if (!rightResults.hasNext()) {
            ArrayList<VisibilityBindingSet> leftResultList = new ArrayList<VisibilityBindingSet>();
            leftResultList.add(newLeftResult);
            return leftResultList.iterator();
        }
        return new LazyJoiningIterator(LazyJoiningIterator.Side.LEFT, newLeftResult, rightResults);
    }

    @Override
    public Iterator<VisibilityBindingSet> newRightResult(Iterator<VisibilityBindingSet> leftResults, VisibilityBindingSet newRightResult) {
        Objects.requireNonNull(leftResults);
        Objects.requireNonNull(newRightResult);
        return new LazyJoiningIterator(LazyJoiningIterator.Side.RIGHT, newRightResult, leftResults);
    }
}

