/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.aggregation;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.rya.api.function.aggregation.AggregationElement;
import org.apache.rya.api.function.aggregation.AggregationFunction;
import org.apache.rya.api.function.aggregation.AggregationState;
import org.apache.rya.api.function.aggregation.AggregationType;
import org.apache.rya.api.model.VisibilityBindingSet;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.query.impl.MapBindingSet;

@DefaultAnnotation(value={NonNull.class})
public final class MinFunction
implements AggregationFunction {
    private final ValueComparator compare = new ValueComparator();

    @Override
    public void update(AggregationElement aggregation, AggregationState state, VisibilityBindingSet childBindingSet) {
        Preconditions.checkArgument((aggregation.getAggregationType() == AggregationType.MIN ? 1 : 0) != 0, (Object)"The MinFunction only accepts MIN AggregationElements.");
        Objects.requireNonNull(state);
        Objects.requireNonNull(childBindingSet);
        String aggregatedName = aggregation.getAggregatedBindingName();
        if (childBindingSet.hasBinding(aggregatedName)) {
            Value min;
            String resultName;
            boolean newBinding;
            MapBindingSet result = state.getBindingSet();
            boolean bl = newBinding = !result.hasBinding(resultName = aggregation.getResultBindingName());
            if (newBinding) {
                min = childBindingSet.getValue(aggregatedName);
            } else {
                Value oldMin = result.getValue(resultName);
                Value chidlMin = childBindingSet.getValue(aggregatedName);
                min = this.compare.compare(chidlMin, oldMin) < 0 ? chidlMin : oldMin;
            }
            result.addBinding(resultName, min);
        }
    }
}

