/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.aggregation;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.rdf4j.query.algebra.AggregateOperator;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.Sum;

@DefaultAnnotation(value={NonNull.class})
public enum AggregationType {
    MIN(Min.class),
    MAX(Max.class),
    COUNT(Count.class),
    SUM(Sum.class),
    AVERAGE(Avg.class);

    private final Class<? extends AggregateOperator> operatorClass;
    private static final ImmutableMap<Class<? extends AggregateOperator>, AggregationType> byOperatorClass;

    private AggregationType(Class<? extends AggregateOperator> operatorClass) {
        this.operatorClass = Objects.requireNonNull(operatorClass);
    }

    public static Optional<AggregationType> byOperatorClass(Class<? extends AggregateOperator> operatorClass) {
        return Optional.ofNullable(byOperatorClass.get(operatorClass));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AggregationType type : AggregationType.values()) {
            builder.put(type.operatorClass, (Object)type);
        }
        byOperatorClass = builder.build();
    }
}

