/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.aggregation;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.rya.api.function.aggregation.AverageState;
import org.eclipse.rdf4j.query.impl.MapBindingSet;

@DefaultAnnotation(value={NonNull.class})
public final class AggregationState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String visibility;
    private final MapBindingSet bindingSet;
    private final Map<String, AverageState> avgStates;

    public AggregationState() {
        this.visibility = "";
        this.bindingSet = new MapBindingSet();
        this.avgStates = new HashMap<String, AverageState>();
    }

    public AggregationState(String visibility, MapBindingSet bindingSet, Map<String, AverageState> avgStates) {
        this.visibility = Objects.requireNonNull(visibility);
        this.bindingSet = Objects.requireNonNull(bindingSet);
        this.avgStates = Objects.requireNonNull(avgStates);
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = Objects.requireNonNull(visibility);
    }

    public MapBindingSet getBindingSet() {
        return this.bindingSet;
    }

    public Map<String, AverageState> getAverageStates() {
        return this.avgStates;
    }

    public int hashCode() {
        return Objects.hash(this.visibility, this.bindingSet, this.avgStates);
    }

    public boolean equals(Object o) {
        if (o instanceof AggregationState) {
            AggregationState state = (AggregationState)o;
            return Objects.equals(this.visibility, state.visibility) && Objects.equals(this.bindingSet, state.bindingSet) && Objects.equals(this.avgStates, state.avgStates);
        }
        return false;
    }
}

