/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.aggregation;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.util.Objects;
import org.apache.rya.api.function.aggregation.AggregationType;

@DefaultAnnotation(value={NonNull.class})
public final class AggregationElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AggregationType aggregationType;
    private final String aggregatedBindingName;
    private final String resultBindingName;

    public AggregationElement(AggregationType aggregationType, String aggregatedBindingName, String resultBindingName) {
        this.aggregationType = Objects.requireNonNull(aggregationType);
        this.aggregatedBindingName = Objects.requireNonNull(aggregatedBindingName);
        this.resultBindingName = Objects.requireNonNull(resultBindingName);
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public String getAggregatedBindingName() {
        return this.aggregatedBindingName;
    }

    public String getResultBindingName() {
        return this.resultBindingName;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregationType, this.aggregatedBindingName, this.resultBindingName});
    }

    public boolean equals(Object o) {
        if (o instanceof AggregationElement) {
            AggregationElement agg = (AggregationElement)o;
            return Objects.equals((Object)this.aggregationType, (Object)agg.aggregationType) && Objects.equals(this.aggregatedBindingName, agg.aggregatedBindingName) && Objects.equals(this.resultBindingName, agg.resultBindingName);
        }
        return false;
    }
}

