/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.ParameterDefinition;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAsNode;
import org.apache.royale.compiler.internal.tree.as.ConfigConditionBlockNode;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.ParameterNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.compiler.tree.as.IVariableExpressionNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.utils.NativeUtils;

public class EmitterUtils {
    public static ITypeNode findTypeNode(IPackageNode node) {
        IScopedNode scope = node.getScopedNode();
        for (int i = 0; i < scope.getChildCount(); ++i) {
            ConfigConditionBlockNode configNode;
            IASNode child = scope.getChild(i);
            if (child instanceof ITypeNode) {
                return (ITypeNode)child;
            }
            if (child.getNodeID() != ASTNodeID.ConfigBlockID || (configNode = (ConfigConditionBlockNode)child).getChildCount() <= 0 || !((child = configNode.getChild(0)) instanceof ITypeNode)) continue;
            return (ITypeNode)child;
        }
        return null;
    }

    public static ITypeDefinition findType(Collection<IDefinition> definitions) {
        for (IDefinition definition : definitions) {
            if (!(definition instanceof ITypeDefinition)) continue;
            return (ITypeDefinition)definition;
        }
        return null;
    }

    public static NamespaceDefinition.INamepaceDeclarationDirective findNamespace(Collection<IDefinition> definitions) {
        for (IDefinition definition : definitions) {
            if (!(definition instanceof NamespaceDefinition.INamepaceDeclarationDirective)) continue;
            return (NamespaceDefinition.INamepaceDeclarationDirective)definition;
        }
        return null;
    }

    public static INamespaceNode findNamespaceNode(IPackageNode node) {
        IScopedNode scope = node.getScopedNode();
        for (int i = 0; i < scope.getChildCount(); ++i) {
            IASNode child = scope.getChild(i);
            if (!(child instanceof INamespaceNode)) continue;
            return (INamespaceNode)child;
        }
        return null;
    }

    public static IFunctionDefinition findFunction(Collection<IDefinition> definitions) {
        for (IDefinition definition : definitions) {
            if (!(definition instanceof IFunctionDefinition)) continue;
            return (IFunctionDefinition)definition;
        }
        return null;
    }

    public static IFunctionNode findFunctionNode(IPackageNode node) {
        IScopedNode scope = node.getScopedNode();
        for (int i = 0; i < scope.getChildCount(); ++i) {
            IASNode child = scope.getChild(i);
            if (!(child instanceof IFunctionNode)) continue;
            return (IFunctionNode)child;
        }
        return null;
    }

    public static IVariableNode findVariableNode(IPackageNode node) {
        IScopedNode scope = node.getScopedNode();
        for (int i = 0; i < scope.getChildCount(); ++i) {
            IASNode child = scope.getChild(i);
            if (!(child instanceof IVariableNode)) continue;
            return (IVariableNode)child;
        }
        return null;
    }

    public static IVariableDefinition findVariable(Collection<IDefinition> definitions) {
        for (IDefinition definition : definitions) {
            if (!(definition instanceof IVariableDefinition)) continue;
            return (IVariableDefinition)definition;
        }
        return null;
    }

    public static ITypeDefinition getTypeDefinition(IDefinitionNode node) {
        ITypeNode tnode = (ITypeNode)node.getAncestorOfType(ITypeNode.class);
        if (tnode != null) {
            return (ITypeDefinition)tnode.getDefinition();
        }
        return null;
    }

    public static boolean isSameClass(IDefinition pdef, IDefinition thisClass, ICompilerProject project) {
        if (pdef == thisClass) {
            return true;
        }
        IClassDefinition cdef = ((ClassDefinition)thisClass).resolveBaseClass(project);
        while (cdef != null) {
            if (cdef == pdef) {
                return true;
            }
            cdef = ((ClassDefinition)cdef).resolveBaseClass(project);
        }
        return false;
    }

    public static boolean hasSuperClass(ICompilerProject project, IDefinitionNode node) {
        IClassDefinition superClassDefinition = EmitterUtils.getSuperClassDefinition(node, project);
        if (superClassDefinition == null) {
            return false;
        }
        String qname = superClassDefinition.getQualifiedName();
        return superClassDefinition != null && !qname.equals("Object");
    }

    public static boolean hasSuperCall(IScopedNode node) {
        for (int i = node.getChildCount() - 1; i > -1; --i) {
            IASNode cnode = node.getChild(i);
            if (cnode.getNodeID() != ASTNodeID.FunctionCallID || cnode.getChild(0).getNodeID() != ASTNodeID.SuperID) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBody(IFunctionNode node) {
        IScopedNode scope = node.getScopedNode();
        return scope.getChildCount() > 0;
    }

    public static IClassDefinition getSuperClassDefinition(IDefinitionNode node, ICompilerProject project) {
        IDefinition parent = node.getDefinition().getParent();
        if (parent instanceof IClassDefinition) {
            IClassDefinition parentClassDef = (IClassDefinition)parent;
            IClassDefinition superClass = parentClassDef.resolveBaseClass(project);
            return superClass;
        }
        return null;
    }

    public static List<String> resolveImports(ITypeDefinition type) {
        ArrayList<String> list = new ArrayList<String>();
        IScopedNode scopeNode = type.getContainedScope().getScopeNode();
        if (scopeNode != null) {
            scopeNode.getAllImports(list);
        } else {
            String[] implicitImports;
            ClassDefinition cdefinition = (ClassDefinition)type;
            for (String imp : implicitImports = cdefinition.getImplicitImports()) {
                list.add(imp);
            }
        }
        return list;
    }

    public static IClassDefinition getClassDefinition(IDefinitionNode node) {
        IClassNode tnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        return tnode != null ? tnode.getDefinition() : null;
    }

    public static IParameterNode getRest(IParameterNode[] nodes) {
        for (IParameterNode node : nodes) {
            if (!node.isRest()) continue;
            return node;
        }
        return null;
    }

    public static Map<Integer, IParameterNode> getDefaults(IParameterNode[] nodes) {
        HashMap<Integer, IParameterNode> result = new HashMap<Integer, IParameterNode>();
        int i = 0;
        boolean hasDefaults = false;
        for (IParameterNode node : nodes) {
            if (node.hasDefaultValue()) {
                hasDefaults = true;
                result.put(i, node);
            } else {
                result.put(i, null);
            }
            ++i;
        }
        if (!hasDefaults) {
            return null;
        }
        return result;
    }

    public static boolean writeThis(ICompilerProject project, JSSessionModel model, IIdentifierNode node) {
        boolean identifierIsMemberAccess;
        IClassNode classNode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        IDefinition nodeDef = node.resolve(project);
        IASNode parentNode = node.getParent();
        ASTNodeID parentNodeId = parentNode.getNodeID();
        IASNode firstChild = parentNode.getChild(0);
        IClassDefinition thisClass = model.getCurrentClass();
        boolean bl = identifierIsMemberAccess = parentNodeId == ASTNodeID.MemberAccessExpressionID;
        if (nodeDef instanceof ParameterDefinition) {
            return false;
        }
        if (nodeDef instanceof InterfaceDefinition) {
            return false;
        }
        if (nodeDef instanceof ClassDefinition) {
            return false;
        }
        if (classNode == null) {
            if (parentNodeId == ASTNodeID.FunctionCallID && model.inE4xFilter) {
                return false;
            }
            if (nodeDef instanceof VariableDefinition) {
                IDefinition pdef = ((VariableDefinition)nodeDef).getParent();
                if (thisClass == null || !EmitterUtils.isSameClass(pdef, (IDefinition)thisClass, project)) {
                    return false;
                }
                if (identifierIsMemberAccess) {
                    return node == firstChild;
                }
                return parentNodeId == ASTNodeID.ContainerID || !(parentNode instanceof ParameterNode);
            }
            if (nodeDef instanceof AccessorDefinition) {
                IDefinition pdef = ((AccessorDefinition)nodeDef).getParent();
                if (thisClass == null || !EmitterUtils.isSameClass(pdef, (IDefinition)thisClass, project)) {
                    return false;
                }
                if (identifierIsMemberAccess) {
                    return node == firstChild;
                }
                return true;
            }
            if (parentNodeId == ASTNodeID.ContainerID && nodeDef instanceof FunctionDefinition) {
                return ((FunctionDefinition)nodeDef).getFunctionClassification() == IFunctionDefinition.FunctionClassification.CLASS_MEMBER;
            }
            boolean isFileOrPackageMember = false;
            boolean isLocalFunction = false;
            if (nodeDef instanceof FunctionDefinition) {
                IFunctionDefinition.FunctionClassification classification = ((FunctionDefinition)nodeDef).getFunctionClassification();
                if (classification == IFunctionDefinition.FunctionClassification.FILE_MEMBER || classification == IFunctionDefinition.FunctionClassification.PACKAGE_MEMBER) {
                    isFileOrPackageMember = true;
                } else {
                    if (!identifierIsMemberAccess && classification == IFunctionDefinition.FunctionClassification.CLASS_MEMBER && EmitterUtils.isClassMember(project, nodeDef, thisClass)) {
                        return true;
                    }
                    if (classification == IFunctionDefinition.FunctionClassification.LOCAL) {
                        isLocalFunction = true;
                    }
                }
            }
            return parentNodeId == ASTNodeID.FunctionCallID && !(nodeDef instanceof AccessorDefinition) && !identifierIsMemberAccess && !isFileOrPackageMember && !isLocalFunction;
        }
        if (parentNodeId == ASTNodeID.FunctionCallID && model.inE4xFilter) {
            return false;
        }
        if (nodeDef != null && EmitterUtils.isClassMember(project, nodeDef, classNode)) {
            if (identifierIsMemberAccess) {
                return node == firstChild;
            }
            boolean identifierIsLocalFunction = nodeDef instanceof FunctionDefinition && !(nodeDef instanceof AccessorDefinition) && ((FunctionDefinition)nodeDef).getFunctionClassification() == IFunctionDefinition.FunctionClassification.LOCAL;
            return !identifierIsLocalFunction;
        }
        return false;
    }

    public static boolean isClassMember(ICompilerProject project, IDefinition nodeDef, IClassNode classNode) {
        IDefinition parentDef = nodeDef.getParent();
        if (nodeDef.isInternal() && !(parentDef instanceof ClassDefinition)) {
            return false;
        }
        IClassDefinition cdef = classNode.getDefinition();
        return parentDef == cdef || parentDef instanceof ClassDefinition && cdef.isInstanceOf((ITypeDefinition)((ClassDefinition)parentDef), project);
    }

    public static boolean isClassMember(ICompilerProject project, IDefinition nodeDef, IClassDefinition classDef) {
        IDefinition parentDef = nodeDef.getParent();
        if (nodeDef.isInternal() && !(parentDef instanceof ClassDefinition)) {
            return false;
        }
        return parentDef == classDef || parentDef instanceof ClassDefinition && ((ClassDefinition)parentDef).isInstanceOf((ITypeDefinition)classDef, project);
    }

    public static boolean writeE4xFilterNode(ICompilerProject project, JSSessionModel model, IExpressionNode node) {
        if (!model.inE4xFilter) {
            return false;
        }
        IDefinition nodeDef = node.resolve(project);
        IASNode parentNode = node.getParent();
        IASNode firstChild = parentNode.getChild(0);
        if (parentNode instanceof IUnaryOperatorNode) {
            return false;
        }
        if (nodeDef instanceof ParameterDefinition) {
            return false;
        }
        if (nodeDef instanceof InterfaceDefinition) {
            return false;
        }
        if (nodeDef instanceof ClassDefinition) {
            return false;
        }
        if (nodeDef instanceof VariableDefinition) {
            List<IVariableNode> list = model.getVars();
            for (IVariableNode element : list) {
                if (!element.getQualifiedName().equals(((IIdentifierNode)node).getName())) continue;
                return false;
            }
        }
        if (node == firstChild) {
            return true;
        }
        if (parentNode instanceof IBinaryOperatorNode && node == parentNode.getChild(1)) {
            return !(parentNode instanceof IMemberAccessExpressionNode);
        }
        return false;
    }

    public static boolean isScalar(IExpressionNode node) {
        IIdentifierNode idnode;
        String idname;
        IASNode child;
        IIdentifierNode idnode2;
        String idname2;
        ASTNodeID id = node.getNodeID();
        if (id == ASTNodeID.LiteralBooleanID || id == ASTNodeID.LiteralIntegerID || id == ASTNodeID.LiteralIntegerZeroID || id == ASTNodeID.LiteralDoubleID || id == ASTNodeID.LiteralNullID || id == ASTNodeID.LiteralNumberID || id == ASTNodeID.LiteralRegexID || id == ASTNodeID.LiteralStringID || id == ASTNodeID.LiteralUintID) {
            return true;
        }
        if (id == ASTNodeID.IdentifierID && ((idname2 = (idnode2 = (IIdentifierNode)node).getName()).equals(NativeUtils.NativeASType.Infinity.name()) || idname2.equals(NativeUtils.NativeASType.undefined.name()) || idname2.equals(NativeUtils.NativeASType.NaN.name()))) {
            return true;
        }
        return id == ASTNodeID.Op_SubtractID && node.getChildCount() == 1 && (child = node.getChild(0)).getNodeID() == ASTNodeID.IdentifierID && (idname = (idnode = (IIdentifierNode)child).getName()).equals(NativeUtils.NativeASType.Infinity.name());
    }

    public static boolean needsStaticInitializer(String node, String className) {
        return node.contains(className);
    }

    public static IContainerNode insertArgumentsBefore(IContainerNode argumentsNode, IASNode ... nodes) {
        int i;
        int originalLength = argumentsNode.getChildCount();
        int extraLength = nodes.length;
        ContainerNode result = new ContainerNode(originalLength + extraLength);
        result.setSourcePath(argumentsNode.getSourcePath());
        result.span((ISourceLocation)argumentsNode);
        result.setParent((NodeBase)argumentsNode.getParent());
        for (i = 0; i < extraLength; ++i) {
            NodeBase node = (NodeBase)nodes[i];
            node.setSourcePath(argumentsNode.getSourcePath());
            result.addItem(node);
        }
        for (i = 0; i < originalLength; ++i) {
            result.addItem((NodeBase)argumentsNode.getChild(i));
        }
        return result;
    }

    public static IContainerNode insertArgumentsAfter(IContainerNode argumentsNode, IASNode ... nodes) {
        int i;
        int originalLength = argumentsNode.getChildCount();
        int extraLength = nodes.length;
        ContainerNode result = new ContainerNode(originalLength + extraLength);
        result.setSourcePath(argumentsNode.getSourcePath());
        result.span((ISourceLocation)argumentsNode);
        result.setParent((NodeBase)argumentsNode.getParent());
        for (i = 0; i < originalLength; ++i) {
            result.addItem((NodeBase)argumentsNode.getChild(i));
        }
        for (i = 0; i < extraLength; ++i) {
            NodeBase node = (NodeBase)nodes[i];
            node.setSourcePath(argumentsNode.getSourcePath());
            result.addItem(node);
        }
        return result;
    }

    public static IContainerNode insertArgumentsAt(IContainerNode argumentsNode, int index, IASNode ... nodes) {
        int originalLength = argumentsNode.getChildCount();
        int extraLength = nodes.length;
        ContainerNode result = new ContainerNode(originalLength + extraLength);
        result.setSourcePath(argumentsNode.getSourcePath());
        result.span((ISourceLocation)argumentsNode);
        result.setParent((NodeBase)argumentsNode.getParent());
        for (int i = 0; i < originalLength; ++i) {
            if (i < index) {
                result.addItem((NodeBase)argumentsNode.getChild(i));
                continue;
            }
            if (i == index) {
                for (IASNode node : nodes) {
                    NodeBase n = (NodeBase)node;
                    n.setSourcePath(argumentsNode.getSourcePath());
                    result.addItem(n);
                }
            }
            result.addItem((NodeBase)argumentsNode.getChild(i));
        }
        return result;
    }

    public static boolean isImplicit(IContainerNode node) {
        return node.getContainerType() == IContainerNode.ContainerType.IMPLICIT || node.getContainerType() == IContainerNode.ContainerType.SYNTHESIZED;
    }

    public static boolean needsDefaultValue(IVariableNode node, boolean defaultInitializers, ICompilerProject project) {
        if (node == null) {
            return false;
        }
        if (node instanceof IParameterNode) {
            return false;
        }
        if (node instanceof IAccessorNode) {
            return false;
        }
        IExpressionNode assignedValueNode = node.getAssignedValueNode();
        if (assignedValueNode != null) {
            return false;
        }
        IASNode parentNode = node.getParent();
        if (parentNode instanceof IVariableExpressionNode) {
            return false;
        }
        IExpressionNode variableTypeNode = node.getVariableTypeNode();
        if (variableTypeNode == null) {
            return false;
        }
        IDefinition varTypeDef = variableTypeNode.resolve(project);
        if (varTypeDef == null) {
            return false;
        }
        if ("*".equals(varTypeDef.getQualifiedName())) {
            return false;
        }
        if (project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE).equals(varTypeDef) || project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE).equals(varTypeDef) || project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE).equals(varTypeDef)) {
            return false;
        }
        if (project.getBuiltinType(IASLanguageConstants.BuiltinType.INT).equals(varTypeDef) || project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT).equals(varTypeDef)) {
            return true;
        }
        return defaultInitializers;
    }

    public static boolean isXMLish(IExpressionNode obj, ICompilerProject project) {
        ITypeDefinition leftDef = obj.resolveType(project);
        if (leftDef == null && obj.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            return EmitterUtils.isXMLish(((MemberAccessExpressionNode)obj).getLeftOperandNode(), project);
        }
        if (leftDef != null && leftDef.getBaseName().equals("*") && obj instanceof DynamicAccessNode) {
            return EmitterUtils.isXMLish(((DynamicAccessNode)obj).getLeftOperandNode(), project);
        }
        return SemanticUtils.isXMLish((IDefinition)leftDef, (ICompilerProject)project);
    }

    public static boolean isXMLList(IMemberAccessExpressionNode obj, ICompilerProject project) {
        IExpressionNode leftNode = obj.getLeftOperandNode();
        IExpressionNode rightNode = obj.getRightOperandNode();
        ASTNodeID rightID = rightNode.getNodeID();
        if (rightID == ASTNodeID.IdentifierID || rightID == ASTNodeID.NamespaceAccessExpressionID && rightNode.getChild(1).getNodeID() == ASTNodeID.IdentifierID) {
            ITypeDefinition rightDef = rightNode.resolveType(project);
            if (rightDef != null) {
                if (SemanticUtils.isXMLish((IDefinition)rightDef, (ICompilerProject)project)) {
                    return EmitterUtils.isLeftNodeXMLish(leftNode, project);
                }
                return false;
            }
            return EmitterUtils.isLeftNodeXMLish(leftNode, project);
        }
        if (rightID == ASTNodeID.Op_AtID) {
            return true;
        }
        return rightNode instanceof IDynamicAccessNode && ((IDynamicAccessNode)rightNode).getLeftOperandNode().getNodeID() == ASTNodeID.Op_AtID;
    }

    public static boolean isLeftNodeXMLList(IExpressionNode leftNode, ICompilerProject project) {
        boolean isXMLList = false;
        if (EmitterUtils.isLeftNodeXMLish(leftNode, project)) {
            if (leftNode instanceof IDynamicAccessNode) {
                IExpressionNode dynAccess = ((IDynamicAccessNode)leftNode).getRightOperandNode();
                ITypeDefinition accessDef = dynAccess.resolveType(project);
                if (SemanticUtils.isNumericType((IDefinition)accessDef, (ICompilerProject)project)) {
                    isXMLList = false;
                }
            } else {
                isXMLList = true;
            }
        }
        return isXMLList;
    }

    public static boolean isLeftNodeXML(IExpressionNode leftNode, ICompilerProject project) {
        boolean isXML = false;
        if (EmitterUtils.isLeftNodeXMLish(leftNode, project)) {
            if (leftNode instanceof IDynamicAccessNode) {
                IExpressionNode dynAccess = ((IDynamicAccessNode)leftNode).getRightOperandNode();
                ITypeDefinition accessDef = dynAccess.resolveType(project);
                if (SemanticUtils.isNumericType((IDefinition)accessDef, (ICompilerProject)project)) {
                    isXML = true;
                }
            } else {
                isXML = false;
            }
        }
        return isXML;
    }

    public static boolean isLeftNodeXMLish(IExpressionNode leftNode, ICompilerProject project) {
        ASTNodeID leftID = leftNode.getNodeID();
        if (leftID == ASTNodeID.IdentifierID) {
            ITypeDefinition leftDef = leftNode.resolveType(project);
            if (leftDef != null) {
                return SemanticUtils.isXMLish((IDefinition)leftDef, (ICompilerProject)project);
            }
        } else {
            if (leftID == ASTNodeID.MemberAccessExpressionID || leftID == ASTNodeID.Op_DescendantsID) {
                ITypeDefinition rightDef;
                MemberAccessExpressionNode maen = (MemberAccessExpressionNode)leftNode;
                IExpressionNode rightNode = maen.getRightOperandNode();
                ASTNodeID rightID = rightNode.getNodeID();
                if (rightID == ASTNodeID.IdentifierID && (rightDef = rightNode.resolveType(project)) != null && rightDef != project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE)) {
                    return SemanticUtils.isXMLish((IDefinition)rightDef, (ICompilerProject)project);
                }
                leftNode = maen.getLeftOperandNode();
                return EmitterUtils.isLeftNodeXMLish(leftNode, project);
            }
            if (leftID == ASTNodeID.FunctionCallID) {
                FunctionCallNode fcn = (FunctionCallNode)leftNode;
                String fname = fcn.getFunctionName();
                if (fname.equals("XML") || fname.equals("XMLList")) {
                    return true;
                }
            } else if (leftID == ASTNodeID.Op_AsID) {
                BinaryOperatorAsNode boan = (BinaryOperatorAsNode)leftNode;
                String fname = ((IdentifierNode)boan.getChild(1)).getName();
                if (fname.equals("XML") || fname.equals("XMLList")) {
                    return true;
                }
            } else if (leftID == ASTNodeID.ArrayIndexExpressionID) {
                ITypeDefinition leftDef = (leftNode = (IExpressionNode)leftNode.getChild(0)).resolveType(project);
                if (leftDef != null) {
                    return SemanticUtils.isXMLish((IDefinition)leftDef, (ICompilerProject)project);
                }
            } else if (leftID == ASTNodeID.E4XFilterID) {
                return true;
            }
        }
        return false;
    }

    public static boolean needsXMLQNameArgumentsPatch(IFunctionCallNode node, ICompilerProject project) {
        String methodName;
        if (node.getNameNode() instanceof MemberAccessExpressionNode && ((MemberAccessExpressionNode)node.getNameNode()).getRightOperandNode() instanceof IdentifierNode && ("child".equals(methodName = ((IdentifierNode)((MemberAccessExpressionNode)node.getNameNode()).getRightOperandNode()).getName()) || "descendants".equals(methodName) || "attribute".equals(methodName))) {
            ITypeDefinition def;
            boolean isXML;
            IExpressionNode leftNode = ((MemberAccessExpressionNode)node.getNameNode()).getLeftOperandNode();
            boolean bl = isXML = leftNode instanceof MemberAccessExpressionNode && EmitterUtils.isLeftNodeXMLish((IExpressionNode)((MemberAccessExpressionNode)leftNode), project);
            if (!isXML) {
                boolean bl2 = isXML = leftNode instanceof IExpressionNode && EmitterUtils.isXMLish(leftNode, project);
            }
            if (isXML && node.getArgumentsNode().getChildCount() == 1 && (def = node.getArgumentNodes()[0].resolveType(project)) != null && def.getQualifiedName().equals("QName")) {
                return true;
            }
        }
        return false;
    }

    public static void createDefaultNamespaceArg(ContainerNode argsNode, int position, IExpressionNode defaultNamespace) {
        argsNode.addChild((NodeBase)defaultNamespace, position);
        ((NodeBase)defaultNamespace).setParent((NodeBase)argsNode);
    }

    public static boolean isCustomNamespace(String ns) {
        if (ns != null) {
            return !ns.equals("private") && !ns.equals("protected") && !ns.equals("internal") && !ns.equals("http://adobe.com/AS3/2006/builtin") && !ns.equals("public");
        }
        return false;
    }
}

