/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.royale;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.asdoc.IASDocTag;
import org.apache.royale.compiler.asdoc.royale.ASDocComment;
import org.apache.royale.compiler.codegen.js.royale.IJSRoyaleASDocEmitter;
import org.apache.royale.compiler.codegen.js.royale.IJSRoyaleEmitter;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.metadata.IDeprecationInfo;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLRoyaleASDocEmitter;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.EventDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleASDocProject;
import org.apache.royale.compiler.internal.tree.as.metadata.EventTagNode;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IGetterNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.ISetterNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.utils.NativeUtils;

public class JSRoyaleASDocEmitter
extends JSGoogEmitter
implements IJSRoyaleEmitter,
IJSRoyaleASDocEmitter {
    private boolean firstMember = true;
    public MXMLRoyaleASDocEmitter mxmlEmitter = null;
    private ArrayList<String> accessors = new ArrayList();

    @Override
    public String postProcess(String output) {
        return output;
    }

    public JSRoyaleASDocEmitter(FilterWriter out) {
        super(out);
    }

    @Override
    protected void writeIndent() {
        this.write(JSRoyaleEmitterTokens.INDENT);
    }

    @Override
    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numIndent; ++i) {
            sb.append(JSRoyaleEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    @Override
    public void emitNamespace(INamespaceNode node) {
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        this.writeNewline("{ \"type\": \"namespace\",");
        this.write("  \"qname\": \"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.writeNewline("\"");
        this.indentPush();
        if (asDoc != null) {
            this.writeNewline(",");
            this.writeASDoc(asDoc, (RoyaleASDocProject)this.getWalker().getProject());
        }
        this.indentPop();
        this.writeNewline("}");
    }

    @Override
    public String formatQualifiedName(String name) {
        return this.formatQualifiedName(name, false);
    }

    public String formatQualifiedName(String name, boolean isDoc) {
        if (this.mxmlEmitter != null) {
            name = this.mxmlEmitter.formatQualifiedName(name);
        }
        if (this.getModel().isInternalClass(name)) {
            return this.getModel().getInternalClasses().get(name);
        }
        if (NativeUtils.isJSNative(name)) {
            return name;
        }
        if (name.startsWith("window.")) {
            name = name.substring(7);
        } else if (!isDoc) {
            // empty if block
        }
        return name;
    }

    public String convertASTypeToJS(String name) {
        String result = name;
        if (name.equals("")) {
            result = "Object";
        } else if (name.equals("Class")) {
            result = "Object";
        } else if (name.equals("int") || name.equals("uint")) {
            result = "Number";
        }
        boolean isBuiltinFunction = name.matches("Vector\\.<.*>");
        if (isBuiltinFunction) {
            result = "Array";
        }
        return result;
    }

    @Override
    public void emitPackageHeader(IPackageDefinition definition) {
        IPackageNode packageNode = definition.getNode();
        IFileNode fileNode = (IFileNode)packageNode.getAncestorOfType(IFileNode.class);
        int nodeCount = fileNode.getChildCount();
        for (int i = 0; i < nodeCount; ++i) {
            IASNode pnode = fileNode.getChild(i);
            if (pnode instanceof IPackageNode || pnode instanceof IClassNode) continue;
            if (pnode instanceof IInterfaceNode) {
                this.getWalker().walk(pnode);
                continue;
            }
            if (pnode instanceof IFunctionNode) {
                this.getWalker().walk(pnode);
                continue;
            }
            if (pnode instanceof INamespaceNode) {
                this.getWalker().walk(pnode);
                continue;
            }
            if (!(pnode instanceof IVariableNode)) continue;
            this.getWalker().walk(pnode);
        }
    }

    @Override
    public void emitPackageHeaderContents(IPackageDefinition definition) {
    }

    @Override
    public void emitPackageFooter(IPackageDefinition definition) {
    }

    @Override
    public void emitClass(IClassNode node) {
        IMetaTagNode[] metas;
        IDefinitionNode[] members;
        if (!node.getDefinition().isPublic()) {
            return;
        }
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        this.writeNewline("{ \"type\": \"class\",");
        this.write("  \"qname\": \"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.writeNewline("\",");
        this.indentPush();
        this.write("  \"baseClassname\": \"");
        IExpressionNode baseNode = node.getBaseClassExpressionNode();
        if (baseNode != null) {
            IDefinition baseDef = baseNode.resolve(this.getWalker().getProject());
            this.write(this.formatQualifiedName(baseDef.getQualifiedName()));
        } else {
            this.write(this.formatQualifiedName(node.getBaseClassName()));
        }
        this.writeNewline("\"");
        if (asDoc != null) {
            this.writeNewline(",");
            this.writeASDoc(asDoc, (RoyaleASDocProject)this.getWalker().getProject());
        }
        if ((members = node.getAllMemberNodes()).length > 0) {
            this.writeNewline(",");
            this.writeNewline("\"members\": [");
            this.indentPush();
            this.indentPush();
        }
        this.firstMember = true;
        for (IDefinitionNode mnode : members) {
            this.getWalker().walk((IASNode)mnode);
        }
        if (members.length > 0) {
            this.indentPop();
            this.indentPop();
            this.writeNewline("]");
        }
        if ((metas = node.getMetaTagNodesByName("Event")).length > 0) {
            this.writeNewline(",");
            this.writeNewline("\"events\": [");
            this.indentPush();
            this.indentPush();
        }
        this.firstMember = true;
        for (IMetaTagNode mnode : metas) {
            this.writeEventTagNode(mnode);
        }
        if (metas.length > 0) {
            this.indentPop();
            this.indentPop();
            this.writeNewline("]");
        }
        this.indentPop();
        this.writeNewline("}");
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
        RoyaleASDocProject project = (RoyaleASDocProject)this.getWalker().getProject();
        RoyaleASDocProject.ASDocRecord record = new RoyaleASDocProject.ASDocRecord(project);
        record.definition = node.getDefinition();
        record.description = asDoc != null ? this.makeShortDescription(asDoc.getDescription()) : "";
        ((RoyaleASDocProject)this.getWalker().getProject()).classes.put(this.formatQualifiedName(node.getQualifiedName()), record);
    }

    @Override
    public void emitInterface(IInterfaceNode node) {
        IDefinitionNode[] members;
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        this.writeNewline("{ \"type\": \"interface\",");
        this.write("  \"qname\": \"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.write("\"");
        IExpressionNode[] bases = node.getExtendedInterfaceNodes();
        if (bases.length > 0) {
            this.writeNewline(",");
            this.writeNewline("\"baseInterfaceNames\": [");
            boolean firstBase = true;
            int n = bases.length;
            for (int i = 0; i < n; ++i) {
                if (!firstBase) {
                    this.writeNewline(", ");
                }
                firstBase = false;
                IDefinition baseDef = bases[i].resolve(this.getWalker().getProject());
                this.write("\"" + this.formatQualifiedName(baseDef.getQualifiedName()) + "\"");
            }
            this.writeNewline("]");
        }
        this.indentPush();
        if (asDoc != null) {
            this.writeNewline(",");
            this.writeASDoc(asDoc, (RoyaleASDocProject)this.getWalker().getProject());
        }
        if ((members = node.getAllMemberDefinitionNodes()).length > 0) {
            this.writeNewline(",");
            this.writeNewline("\"members\": [");
        }
        this.firstMember = true;
        for (IDefinitionNode mnode : members) {
            this.getWalker().walk((IASNode)mnode);
        }
        if (members.length > 0) {
            this.writeNewline("]");
        }
        this.indentPop();
        this.writeNewline("}");
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
        RoyaleASDocProject project = (RoyaleASDocProject)this.getWalker().getProject();
        RoyaleASDocProject.ASDocRecord record = new RoyaleASDocProject.ASDocRecord(project);
        record.definition = node.getDefinition();
        record.description = asDoc != null ? this.makeShortDescription(asDoc.getDescription()) : "";
        ((RoyaleASDocProject)this.getWalker().getProject()).classes.put(this.formatQualifiedName(node.getQualifiedName()), record);
    }

    @Override
    public void emitGetAccessor(IGetterNode node) {
        if (node.getDefinition().isPrivate()) {
            return;
        }
        String name = node.getName();
        if (this.accessors.contains(name)) {
            return;
        }
        this.accessors.add(name);
        if (!this.firstMember) {
            this.writeNewline(",");
        }
        this.firstMember = false;
        this.writeNewline("{ \"type\": \"accessor\",");
        IAccessorDefinition def = (IAccessorDefinition)node.getDefinition();
        IAccessorDefinition otherDef = def.resolveCorrespondingAccessor(this.getWalker().getProject());
        IAccessorNode otherNode = null;
        if (otherDef != null) {
            otherNode = (IAccessorNode)otherDef.getNode();
            this.writeNewline("  \"access\": \"read-write\",");
        } else {
            this.writeNewline("  \"access\": \"read-only\",");
        }
        this.write("  \"return\": \"");
        this.write(this.formatQualifiedName(node.getReturnTypeNode().resolveType(this.getWalker().getProject()).getQualifiedName()));
        this.writeNewline("\",");
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if ((asDoc == null || asDoc.commentNoEnd().contains("@private")) && otherNode != null) {
            asDoc = (ASDocComment)otherNode.getASDocComment();
        }
        this.write("  \"qname\": \"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.writeNewline("\",");
        this.writeDefinitionAttributes((IDefinition)def);
        this.indentPush();
        if (asDoc != null) {
            this.writeNewline(",");
            this.writeASDoc(asDoc, (RoyaleASDocProject)this.getWalker().getProject());
        }
        this.indentPop();
        this.write("}");
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
    }

    @Override
    public void emitSetAccessor(ISetterNode node) {
        if (node.getDefinition().isPrivate()) {
            return;
        }
        String name = node.getName();
        if (this.accessors.contains(name)) {
            return;
        }
        this.accessors.add(name);
        if (!this.firstMember) {
            this.writeNewline(",");
        }
        this.firstMember = false;
        this.writeNewline("{ \"type\": \"accessor\",");
        IAccessorDefinition def = (IAccessorDefinition)node.getDefinition();
        IAccessorDefinition otherDef = def.resolveCorrespondingAccessor(this.getWalker().getProject());
        IAccessorNode otherNode = null;
        if (otherDef != null) {
            otherNode = (IAccessorNode)otherDef.getNode();
            this.writeNewline("  \"access\": \"read-write\",");
        } else {
            this.writeNewline("  \"access\": \"write-only\",");
        }
        this.write("  \"return\": \"");
        this.write(this.formatQualifiedName(node.getParameterNodes()[0].getVariableTypeNode().resolveType(this.getWalker().getProject()).getQualifiedName()));
        this.writeNewline("\",");
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if ((asDoc == null || asDoc.commentNoEnd().contains("@private")) && otherNode != null) {
            asDoc = (ASDocComment)otherNode.getASDocComment();
        }
        this.write("  \"qname\": \"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.writeNewline("\",");
        this.writeDefinitionAttributes((IDefinition)def);
        this.indentPush();
        if (asDoc != null) {
            this.writeNewline(",");
            this.writeASDoc(asDoc, (RoyaleASDocProject)this.getWalker().getProject());
        }
        this.indentPop();
        this.write("}");
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
    }

    @Override
    public void emitField(IVariableNode node) {
        if (node.getDefinition().isPrivate()) {
            return;
        }
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        if (!this.firstMember) {
            this.writeNewline(",");
        }
        this.firstMember = false;
        this.writeNewline("{ \"type\": \"field\",");
        this.write("  \"qname\": \"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.writeNewline("\",");
        this.write("  \"return\": \"");
        this.write(this.formatQualifiedName(node.getVariableTypeNode().resolveType(this.getWalker().getProject()).getQualifiedName()));
        this.writeNewline("\",");
        this.writeDefinitionAttributes(node.getDefinition());
        this.indentPush();
        if (asDoc != null) {
            this.writeNewline(",");
            this.writeASDoc(asDoc, (RoyaleASDocProject)this.getWalker().getProject());
        }
        this.indentPop();
        this.write("}");
        this.addToIndex(node.getDefinition(), asDoc);
    }

    @Override
    public void emitVarDeclaration(IVariableNode node) {
        if (node.getDefinition().isPrivate()) {
            return;
        }
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        if (!this.firstMember) {
            this.writeNewline(",");
        }
        this.firstMember = false;
        this.writeNewline("{ \"type\": \"variable\",");
        this.write("  \"qname\": \"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.writeNewline("\",");
        this.writeDefinitionAttributes(node.getDefinition());
        this.indentPush();
        if (asDoc != null) {
            this.writeNewline(",");
            this.writeASDoc(asDoc, (RoyaleASDocProject)this.getWalker().getProject());
        }
        this.indentPop();
        this.write("}");
        this.addToIndex(node.getDefinition(), asDoc);
    }

    @Override
    public void emitAccessors(IAccessorNode node) {
        if (node.getDefinition().isPrivate()) {
            return;
        }
        String name = node.getName();
        if (this.accessors.contains(name)) {
            return;
        }
        if (!this.firstMember) {
            this.writeNewline(",");
        }
        this.firstMember = false;
        this.accessors.add(name);
        this.writeNewline("{ \"type\": \"accessor\",");
        IAccessorDefinition def = (IAccessorDefinition)node.getDefinition();
        IAccessorDefinition otherDef = def.resolveCorrespondingAccessor(this.getWalker().getProject());
        IAccessorNode otherNode = null;
        if (otherDef != null) {
            otherNode = (IAccessorNode)otherDef.getNode();
            this.writeNewline("  \"access\": \"read-write\",");
        } else {
            this.writeNewline("  \"access\": \"read-only\",");
        }
        this.write("  \"return\": \"");
        this.write(this.formatQualifiedName(node.isGetter() ? node.getReturnType() : node.getParameterNodes()[0].getQualifiedName()));
        this.writeNewline("\",");
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if ((asDoc == null || asDoc.commentNoEnd().contains("@private")) && otherNode != null) {
            asDoc = (ASDocComment)otherNode.getASDocComment();
        }
        this.write("  \"qname\": \"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.writeNewline("\",");
        this.writeDefinitionAttributes((IDefinition)def);
        this.indentPush();
        if (asDoc != null) {
            this.writeNewline(",");
            this.writeASDoc(asDoc, (RoyaleASDocProject)this.getWalker().getProject());
        }
        this.indentPop();
        this.write("}");
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
    }

    @Override
    public void emitMethod(IFunctionNode node) {
        IParameterDefinition[] params;
        if (node.getDefinition().isPrivate()) {
            return;
        }
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        if (!this.firstMember) {
            this.writeNewline(",");
        }
        this.firstMember = false;
        this.writeNewline("{ \"type\": \"method\",");
        this.write("  \"qname\": \"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.writeNewline("\",");
        this.writeDefinitionAttributes((IDefinition)node.getDefinition());
        this.indentPush();
        this.writeNewline(",");
        if (asDoc != null) {
            this.writeASDoc(asDoc, (RoyaleASDocProject)this.getWalker().getProject());
            this.writeNewline(",");
        }
        this.write("  \"return\": \"");
        if (node.getReturnType().equals("void")) {
            this.write("void");
        } else if (node.getReturnTypeNode() != null) {
            this.write(this.formatQualifiedName(node.getReturnTypeNode().resolveType(this.getWalker().getProject()).getQualifiedName()));
        }
        this.writeNewline("\",");
        this.write("  \"params\": [");
        boolean firstParam = true;
        for (IParameterDefinition param : params = node.getDefinition().getParameters()) {
            if (!firstParam) {
                this.writeNewline(",");
            }
            firstParam = false;
            this.write("{ \"name\": \"");
            this.write(param.getBaseName());
            this.write("\", \"type\": \"");
            if (param.getTypeReference() != null) {
                this.write(this.formatQualifiedName(param.getTypeReference().resolve(this.getWalker().getProject(), node.getContainingScope().getScope(), DependencyType.SIGNATURE, false).getQualifiedName()));
            }
            this.write("\"}");
        }
        this.write("]");
        this.indentPop();
        this.writeNewline("}");
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
    }

    public void writeASDoc(ASDocComment asDoc, RoyaleASDocProject project) {
        List<String> tagList = project.tags;
        asDoc.compile();
        this.write("  \"description\": \"");
        String d = asDoc.getDescription();
        d = d.replace("\t", " ");
        d = d.replace("\\\"", "&quot;");
        d = d.replace("\\", "\\\\");
        this.write(d);
        this.write("\"");
        Map<String, List<IASDocTag>> tags = asDoc.getTags();
        if (tags != null) {
            this.writeNewline(",");
            this.writeNewline("\"tags\": [");
            this.indentPush();
            this.indentPush();
            boolean firstTag = true;
            Set<String> tagNames = tags.keySet();
            for (String tagName : tagNames) {
                if (!firstTag) {
                    this.writeNewline(",");
                }
                firstTag = false;
                this.write("{  \"tagName\": \"");
                tagName = tagName.trim();
                this.write(tagName);
                if (!tagList.contains(tagName)) {
                    tagList.add(tagName);
                }
                this.writeNewline("\",");
                this.write("   \"values\": [");
                this.indentPush();
                this.indentPush();
                List<IASDocTag> values = tags.get(tagName);
                if (values != null) {
                    boolean firstOne = true;
                    for (IASDocTag value : values) {
                        if (!firstOne) {
                            this.write(", ");
                        }
                        firstOne = false;
                        this.write("\"");
                        d = value.getDescription().trim();
                        d = d.replace("\t", " ");
                        d = d.replace("\\\"", "&quot;");
                        d = d.replace("\\", "\\\\");
                        this.write(d);
                        this.write("\"");
                    }
                }
                this.write("]}");
                this.indentPop();
                this.indentPop();
            }
            this.write("  ]");
            this.indentPop();
            this.indentPop();
        }
    }

    public void writeDefinitionAttributes(IDefinition def) {
        this.write("  \"namespace\": ");
        if (def.isProtected()) {
            this.write("\"protected\"");
        } else if (def.isInternal()) {
            this.write("\"internal\"");
        } else if (def.isPublic()) {
            this.write("\"public\"");
        } else {
            INamespaceReference nsRef = def.getNamespaceReference();
            this.write("\"" + nsRef.getBaseName() + "\"");
        }
        this.writeNewline(",");
        if (def.isBindable()) {
            List events = def.getBindableEventNames();
            this.write("  \"bindable\": [");
            boolean firstEvent = true;
            for (String event : events) {
                if (!firstEvent) {
                    this.write(",");
                }
                firstEvent = false;
                this.write("\"" + event + "\"");
            }
            this.write("]");
        } else {
            this.write("  \"bindable\": []");
        }
        this.writeNewline(",");
        this.write("  \"details\": [");
        String sep = "";
        if (def.isOverride()) {
            this.write(sep + "\"override\"");
            sep = ",";
        }
        if (def.isStatic()) {
            this.write(sep + "\"static\"");
            sep = ",";
        }
        if (def.isDynamic()) {
            this.write(sep + "\"dynamic\"");
            sep = ",";
        }
        if (def.isFinal()) {
            this.write(sep + "\"final\"");
        }
        this.write("]");
        this.writeNewline(",");
        if (def.isDeprecated()) {
            String since;
            String replace;
            IDeprecationInfo dep = def.getDeprecationInfo();
            this.writeNewline("  \"deprecated\": {");
            this.indentPush();
            String comma = "";
            String msg = dep.getMessage();
            if (msg != null) {
                this.write("  \"message\":  \"");
                this.write(msg);
                this.write("\"");
                comma = ",";
            }
            if ((replace = dep.getReplacement()) != null) {
                this.writeNewline(comma);
                this.write("  \"replacement\":  \"");
                this.write(replace);
                this.write("\"");
                comma = ",";
            }
            if ((since = dep.getSince()) != null) {
                this.writeNewline("\",");
                this.write("  \"since\":  \"");
                this.write(since);
                this.write("\"");
                comma = ",";
            }
            this.writeNewline("}");
        } else {
            this.write("  \"deprecated\": {}");
        }
    }

    public void writeEventTagNode(IMetaTagNode node) {
        EventTagNode evt = (EventTagNode)node;
        ASDocComment asDoc = (ASDocComment)evt.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        if (!this.firstMember) {
            this.writeNewline(",");
        }
        this.firstMember = false;
        this.write("{ \"qname\": \"");
        this.write(this.formatQualifiedName(evt.getValue("name")));
        this.writeNewline("\",");
        this.write("  \"type\": \"");
        this.write(evt.getValue("type"));
        this.writeNewline("\"");
        this.indentPush();
        if (asDoc != null) {
            this.writeNewline(",");
            this.writeASDoc(asDoc, (RoyaleASDocProject)this.getWalker().getProject());
        }
        this.indentPop();
        this.write("}");
        this.addToIndex(evt.getDefinition(), asDoc);
    }

    private void addToIndex(IDefinition def, ASDocComment asDoc) {
        RoyaleASDocProject project = (RoyaleASDocProject)this.getWalker().getProject();
        List<RoyaleASDocProject.ASDocRecord> list = project.index.get(def.getBaseName());
        if (list == null) {
            list = new ArrayList<RoyaleASDocProject.ASDocRecord>();
            project.index.put(def.getBaseName(), list);
        }
        RoyaleASDocProject.ASDocRecord record = new RoyaleASDocProject.ASDocRecord(project);
        record.definition = def;
        record.description = asDoc != null ? this.makeShortDescription(asDoc.getDescription()) : "";
        list.add(record);
    }

    private String makeShortDescription(String description) {
        int c = description.indexOf(".");
        if (c != -1) {
            return description.substring(0, c + 1);
        }
        return description;
    }

    private String getMiddle(RoyaleASDocProject project) {
        Map defs = project.config.getCompilerDefine();
        String swf = (String)defs.get("COMPILE::SWF");
        String middle = "";
        if (swf != null) {
            middle = swf.equals("true") ? ".swf" : ".js";
        }
        return middle;
    }

    @Override
    public void outputIndex(File outputFolder, RoyaleASDocProject project) throws IOException {
        File indexFile = new File(outputFolder, "index" + this.getMiddle(project) + ".json");
        BufferedWriter out = new BufferedWriter(new FileWriter(indexFile));
        out.write("{  \"index\": [");
        if (project.config.isVerbose()) {
            System.out.println("Compiling file: " + indexFile);
        }
        Set<String> keys = project.index.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keys);
        Collections.sort(keyList);
        boolean firstLine = true;
        for (String key : keyList) {
            List<RoyaleASDocProject.ASDocRecord> list = project.index.get(key);
            for (RoyaleASDocProject.ASDocRecord record : list) {
                if (!firstLine) {
                    out.write(",\n");
                }
                firstLine = false;
                out.write("{ \"name\": \"");
                out.write(key);
                out.write("\",\n");
                out.write("  \"type\": ");
                if (record.definition instanceof ClassDefinition) {
                    out.write("\"Class\",\n");
                } else if (record.definition instanceof InterfaceDefinition) {
                    out.write("\"Interface\",\n");
                } else if (record.definition instanceof EventDefinition) {
                    out.write("\"Event\",\n");
                } else if (record.definition instanceof AccessorDefinition) {
                    out.write("\"Property\",\n");
                    out.write("  \"class\": \"");
                    out.write(this.formatQualifiedName(record.definition.getParent().getQualifiedName()));
                    out.write("\",\n");
                } else if (record.definition instanceof VariableDefinition) {
                    out.write("\"Property\",\n");
                    out.write("  \"class\": \"");
                    out.write(this.formatQualifiedName(record.definition.getParent().getQualifiedName()));
                    out.write("\",\n");
                } else if (record.definition instanceof FunctionDefinition) {
                    out.write("\"Method\",\n");
                    out.write("  \"class\": \"");
                    out.write(this.formatQualifiedName(record.definition.getParent().getQualifiedName()));
                    out.write("\",\n");
                }
                out.write("  \"description\": \"");
                out.write(record.description);
                out.write("\"}");
            }
        }
        out.write("]}");
        try {
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasCommentaryTags(ASDocComment asDoc) {
        Map<String, List<IASDocTag>> tags = asDoc.getTags();
        if (tags != null) {
            Set<String> tagNames = tags.keySet();
            for (String tagName : tagNames) {
                if (!tagName.equals("flexcomponent")) continue;
                return true;
            }
        }
        return false;
    }

    private void writeCommentaryValues(BufferedWriter commentaryWriter, List<IASDocTag> values) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        boolean firstOne = true;
        for (IASDocTag value : values) {
            String description = value.getDescription().trim();
            if (map.containsKey(description)) continue;
            if (!firstOne) {
                commentaryWriter.write(", ");
            }
            firstOne = false;
            commentaryWriter.write("\"");
            commentaryWriter.write(description);
            commentaryWriter.write("\"");
            map.put(description, "true");
        }
    }

    public void writeCommentaryFile(BufferedWriter commentaryWriter, String qname, ASDocComment asDoc) throws IOException {
        Map<String, List<IASDocTag>> tags = asDoc.getTags();
        if (tags != null) {
            Set<String> tagNames = tags.keySet();
            commentaryWriter.write("{");
            commentaryWriter.write("\"className\": \"");
            commentaryWriter.write(qname);
            commentaryWriter.write("\", ");
            commentaryWriter.write("\"description\": \"");
            commentaryWriter.write(asDoc.getDescription());
            commentaryWriter.write("\", ");
            boolean wroteCommentary = false;
            boolean wroteExample = false;
            boolean firstTag = true;
            for (String tagName : tagNames) {
                tagName = tagName.trim();
                List<IASDocTag> values = tags.get(tagName);
                if (tagName.equals("flexcomponent")) {
                    if (!firstTag) {
                        commentaryWriter.write(", ");
                    }
                    firstTag = false;
                    commentaryWriter.write("\"flexcomponent\": ");
                    commentaryWriter.write("[");
                    if (values != null) {
                        this.writeCommentaryValues(commentaryWriter, values);
                    }
                    commentaryWriter.write("]");
                    continue;
                }
                if (tagName.equals("flexdocurl")) {
                    if (!firstTag) {
                        commentaryWriter.write(", ");
                    }
                    firstTag = false;
                    commentaryWriter.write("\"flexdocurl\": ");
                    commentaryWriter.write("[");
                    if (values != null) {
                        this.writeCommentaryValues(commentaryWriter, values);
                    }
                    commentaryWriter.write("]");
                    continue;
                }
                if (tagName.equals("commentary")) {
                    if (!firstTag) {
                        commentaryWriter.write(", ");
                    }
                    firstTag = false;
                    commentaryWriter.write("\"commentary\": ");
                    commentaryWriter.write("[");
                    if (values != null) {
                        this.writeCommentaryValues(commentaryWriter, values);
                    }
                    commentaryWriter.write("]");
                    wroteCommentary = true;
                    continue;
                }
                if (!tagName.equals("example")) continue;
                if (!firstTag) {
                    commentaryWriter.write(", ");
                }
                firstTag = false;
                commentaryWriter.write("\"example\": ");
                commentaryWriter.write("[");
                if (values != null) {
                    this.writeCommentaryValues(commentaryWriter, values);
                }
                commentaryWriter.write("]");
                wroteExample = true;
            }
            if (!wroteCommentary) {
                commentaryWriter.write(", ");
                commentaryWriter.write("\"commentary\": []");
            }
            if (!wroteExample) {
                commentaryWriter.write(", ");
                commentaryWriter.write("\"example\": []");
            }
            commentaryWriter.write("}");
        }
    }

    @Override
    public void outputClasses(File outputFolder, RoyaleASDocProject project) throws IOException {
        File indexFile = new File(outputFolder, "classes" + this.getMiddle(project) + ".json");
        BufferedWriter out = new BufferedWriter(new FileWriter(indexFile));
        out.write("{  \"classes\": [");
        if (project.config.isVerbose()) {
            System.out.println("Compiling file: " + indexFile);
        }
        Set<String> keys = project.classes.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keys);
        Collections.sort(keyList);
        boolean firstLine = true;
        ArrayList<ASDocComment> commentaryList = new ArrayList<ASDocComment>();
        ArrayList<String> qnameList = new ArrayList<String>();
        for (String string : keyList) {
            if (!firstLine) {
                out.write(",\n");
            }
            firstLine = false;
            RoyaleASDocProject.ASDocRecord record = project.classes.get(string);
            out.write("{ \"name\": \"");
            out.write(string);
            out.write("\",\n");
            DefinitionBase def = (DefinitionBase)record.definition;
            ASDocComment asDoc = (ASDocComment)def.getExplicitSourceComment();
            if (asDoc != null) {
                this.setBufferWrite(true);
                StringBuilder sb = new StringBuilder();
                this.setBuilder(sb);
                this.writeASDoc(asDoc, project);
                this.setBufferWrite(false);
                out.write(sb.toString());
                if (this.hasCommentaryTags(asDoc)) {
                    qnameList.add(string);
                    commentaryList.add(asDoc);
                }
            } else {
                out.write("  \"description\": \"");
                out.write(record.description);
                out.write("\"");
            }
            out.write("}");
        }
        out.write("]}");
        try {
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File listFile = new File(outputFolder, "classlist" + this.getMiddle(project) + ".json");
        out = new BufferedWriter(new FileWriter(listFile));
        out.write("{  \"classnames\": [");
        if (project.config.isVerbose()) {
            System.out.println("Compiling file: " + listFile);
        }
        firstLine = true;
        for (String key : keyList) {
            if (!firstLine) {
                out.write(",\n");
            }
            firstLine = false;
            out.write("\"");
            out.write(key);
            out.write("\"");
        }
        out.write("]}");
        try {
            out.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (commentaryList.size() > 0) {
            File file = new File(outputFolder, "commentary" + this.getMiddle(project) + ".json");
            BufferedWriter commentaryWriter = new BufferedWriter(new FileWriter(file));
            commentaryWriter.write("{ \"list\": [");
            if (project.config.isVerbose()) {
                System.out.println("Building commentary comparison file: " + file);
            }
            firstLine = true;
            int index = 0;
            for (ASDocComment asDoc : commentaryList) {
                if (!firstLine) {
                    commentaryWriter.write(",\n");
                }
                firstLine = false;
                String qname = (String)qnameList.get(index);
                this.writeCommentaryFile(commentaryWriter, qname, asDoc);
                ++index;
            }
            commentaryWriter.write("]}");
            try {
                commentaryWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                commentaryWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void outputTags(File outputFolder, RoyaleASDocProject project) throws IOException {
        File indexFile = new File(outputFolder, "tags" + this.getMiddle(project) + ".json");
        BufferedWriter out = new BufferedWriter(new FileWriter(indexFile));
        out.write("{  \"tags\": [");
        if (project.config.isVerbose()) {
            System.out.println("Compiling file: " + indexFile);
        }
        Collections.sort(project.tags);
        boolean firstLine = true;
        for (String tag : project.tags) {
            if (!firstLine) {
                out.write(",\n");
            }
            firstLine = false;
            out.write("\"");
            out.write(tag);
            out.write("\"");
        }
        out.write("]}");
        try {
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

