/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.goog;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.royale.compiler.codegen.IASGlobalFunctionConstants;
import org.apache.royale.compiler.codegen.IEmitterTokens;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.codegen.js.goog.IJSGoogDocEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.JSDocEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogDocEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.TypedExpressionNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDocumentNode;

public class JSGoogDocEmitter
extends JSDocEmitter
implements IJSGoogDocEmitter {
    public JSGoogDocEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emitInterfaceDoc(IInterfaceNode node, ICompilerProject project) {
        IExpressionNode[] inodes;
        this.begin();
        this.emitJSDocLine(JSEmitterTokens.INTERFACE.getToken());
        boolean hasQualifiedNames = true;
        for (IExpressionNode inode : inodes = node.getExtendedInterfaceNodes()) {
            IDefinition dnode = inode.resolve(project);
            if (dnode == null) {
                hasQualifiedNames = false;
                break;
            }
            this.emitJSDocLine(ASEmitterTokens.EXTENDS, this.formatQualifiedName(dnode.getQualifiedName()));
        }
        if (!hasQualifiedNames) {
            String[] inames;
            for (String iname : inames = node.getExtendedInterfaces()) {
                this.emitJSDocLine(ASEmitterTokens.EXTENDS, iname);
            }
        }
        this.end();
    }

    @Override
    public void emitInterfaceMemberDoc(IDefinitionNode node, ICompilerProject project) {
    }

    @Override
    public void emitFieldDoc(IVariableNode node, IDefinition def, ICompilerProject project) {
        this.begin();
        String ns = node.getNamespace();
        if (ns == "private") {
            this.emitPrivate((IASNode)node);
        } else if (ns == "protected") {
            this.emitProtected((IASNode)node);
        }
        if (node.isConst()) {
            this.emitConst(node);
        }
        String packageName = "";
        if (def != null) {
            packageName = def.getPackageName();
        }
        this.emitType((IASNode)node, packageName, project);
        this.end();
    }

    @Override
    public void emitMethodDoc(IFunctionNode node, ICompilerProject project) {
        IClassDefinition classDefinition = this.resolveClassDefinition(node);
        if (node instanceof IFunctionNode) {
            IClassDefinition parameters;
            boolean hasDoc = false;
            if (node.isConstructor()) {
                IReference[] references;
                this.begin();
                hasDoc = true;
                this.emitJSDocLine(JSEmitterTokens.CONSTRUCTOR);
                IClassDefinition parent = (IClassDefinition)node.getDefinition().getParent();
                IClassDefinition superClass = parent.resolveBaseClass(project);
                String qname = superClass.getQualifiedName();
                if (superClass != null && !qname.equals("Object")) {
                    this.emitExtends(superClass, superClass.getPackageName());
                }
                for (IReference iReference : references = classDefinition.getImplementedInterfaceReferences()) {
                    ITypeDefinition type = (ITypeDefinition)iReference.resolve(project, (IASScope)((ASScope)classDefinition.getContainingScope()), DependencyType.INHERITANCE, true);
                    this.emitImplements(type, type.getPackageName());
                }
            } else if (this.containsThisReference((IASNode)node)) {
                this.begin();
                this.emitMethodAccess(node);
                hasDoc = true;
                this.emitThis((ITypeDefinition)classDefinition, classDefinition.getPackageName());
            }
            for (IClassDefinition pnode : parameters = node.getParameterNodes()) {
                if (!hasDoc) {
                    this.begin();
                    this.emitMethodAccess(node);
                    hasDoc = true;
                }
                IExpressionNode enode = pnode.getNameExpressionNode();
                this.emitParam((IParameterNode)pnode, enode.resolveType(project).getPackageName());
            }
            if (!node.isConstructor()) {
                Boolean override;
                String returnType = node.getReturnType();
                if (returnType != "" && returnType != ASEmitterTokens.VOID.getToken()) {
                    if (!hasDoc) {
                        this.begin();
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    this.emitReturn(node, node.getPackageName());
                }
                if ((override = Boolean.valueOf(node.hasModifier(ASModifier.OVERRIDE))).booleanValue()) {
                    if (!hasDoc) {
                        this.begin();
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    this.emitOverride(node);
                }
            }
            if (hasDoc) {
                this.end();
            }
        }
    }

    public void emitMethodAccess(IFunctionNode node) {
    }

    @Override
    public void emitVarDoc(IVariableNode node, IDefinition def, ICompilerProject project) {
        String packageName = "";
        if (def != null) {
            packageName = def.getPackageName();
        }
        if (!node.isConst()) {
            ITypeDefinition type;
            IDefinition ndef = node.getDefinition();
            if (this.emitter != null && this.emitter instanceof JSRoyaleEmitter && (type = ndef.resolveType(project)) != null) {
                packageName = type.getPackageName();
            }
            this.emitTypeShort((IASNode)node, project.getActualPackageName(packageName), project);
        } else {
            this.writeNewline();
            this.begin();
            this.emitConst(node);
            this.emitType((IASNode)node, project.getActualPackageName(packageName), project);
            this.end();
        }
    }

    @Override
    public void emitConst(IVariableNode node) {
        this.emitJSDocLine(ASEmitterTokens.CONST);
    }

    @Override
    public void emitExtends(IClassDefinition superDefinition, String packageName) {
        this.emitJSDocLine(ASEmitterTokens.EXTENDS, this.formatQualifiedName(superDefinition.getQualifiedName()));
    }

    @Override
    public void emitImplements(ITypeDefinition definition, String packageName) {
        this.emitJSDocLine(ASEmitterTokens.IMPLEMENTS, this.formatQualifiedName(definition.getQualifiedName()));
    }

    @Override
    public void emitOverride(IFunctionNode node) {
        this.emitJSDocLine(ASEmitterTokens.OVERRIDE);
    }

    @Override
    public void emitParam(IParameterNode node, String packageName) {
        String postfix = node.getDefaultValue() == null ? "" : ASEmitterTokens.EQUAL.getToken();
        String paramType = "";
        if (node.isRest()) {
            paramType = ASEmitterTokens.ELLIPSIS.getToken();
        } else {
            String[] parts;
            String typeName = node.getVariableType();
            if (packageName.length() > 0 && typeName.indexOf(packageName) > -1 && (parts = typeName.split("\\.")).length > 0) {
                typeName = parts[parts.length - 1];
            }
            paramType = this.convertASTypeToJS(typeName, packageName);
        }
        this.emitJSDocLine(JSGoogDocEmitterTokens.PARAM, paramType + postfix, node.getName());
    }

    @Override
    public void emitPrivate(IASNode node) {
        this.emitJSDocLine(ASEmitterTokens.PRIVATE);
    }

    @Override
    public void emitProtected(IASNode node) {
        this.emitJSDocLine(ASEmitterTokens.PROTECTED);
    }

    @Override
    public void emitPublic(IASNode node) {
        this.emitJSDocLine(JSGoogDocEmitterTokens.EXPORT);
    }

    @Override
    public void emitReturn(IFunctionNode node, String packageName) {
        String rtype = node.getReturnType();
        if (rtype != null) {
            this.emitJSDocLine(ASEmitterTokens.RETURN, this.convertASTypeToJS(rtype, packageName));
        }
    }

    @Override
    public void emitThis(ITypeDefinition type, String packageName) {
        this.emitJSDocLine(ASEmitterTokens.THIS.getToken(), type.getQualifiedName());
    }

    @Override
    public void emitType(IASNode node, String packageName, ICompilerProject project) {
        ITypeDefinition elemenTypeDef;
        String type = ((IVariableNode)node).getVariableType();
        if (((IVariableNode)node).getVariableTypeNode() instanceof TypedExpressionNode && (elemenTypeDef = ((TypedExpressionNode)((IVariableNode)node).getVariableTypeNode()).getTypeNode().resolveType(project)) != null) {
            type = "Vector.<" + this.convertASTypeToJS(elemenTypeDef.getQualifiedName(), "") + ">";
            packageName = "";
        }
        this.emitJSDocLine(JSGoogDocEmitterTokens.TYPE.getToken(), this.convertASTypeToJS(type, packageName));
    }

    @Override
    public void emitType(String type, String packageName) {
        this.emitJSDocLine(JSGoogDocEmitterTokens.TYPE.getToken(), this.convertASTypeToJS(type, packageName));
    }

    public void emitTypeShort(IASNode node, String packageName, ICompilerProject project) {
        ITypeDefinition elemenTypeDef;
        String type = ((IVariableNode)node).getVariableType();
        if (((IVariableNode)node).getVariableTypeNode() instanceof TypedExpressionNode && (elemenTypeDef = ((TypedExpressionNode)((IVariableNode)node).getVariableTypeNode()).getTypeNode().resolveType(project)) != null) {
            type = "Vector.<" + this.convertASTypeToJS(elemenTypeDef.getQualifiedName(), "") + ">";
            packageName = "";
        }
        this.writeToken(JSDocEmitterTokens.JSDOC_OPEN);
        this.write(ASEmitterTokens.ATSIGN);
        this.writeToken(JSGoogDocEmitterTokens.TYPE);
        this.writeBlockOpen();
        this.write(this.convertASTypeToJS(type, packageName));
        this.writeBlockClose();
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(JSDocEmitterTokens.JSDOC_CLOSE);
    }

    public void emmitPackageHeader(IPackageNode node) {
        this.begin();
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(JSGoogDocEmitterTokens.STAR);
        this.write(JSGoogDocEmitter.getTimeStampString());
        this.end();
    }

    protected void emitJSDocLine(IEmitterTokens name) {
        this.emitJSDocLine(name.getToken(), "");
    }

    private void emitJSDocLine(String name) {
        this.emitJSDocLine(name, "");
    }

    protected void emitJSDocLine(IEmitterTokens name, String type) {
        this.emitJSDocLine(name.getToken(), type, "");
    }

    private void emitJSDocLine(String name, String type) {
        this.emitJSDocLine(name, type, "");
    }

    private void emitJSDocLine(IEmitterTokens name, String type, String param) {
        this.emitJSDocLine(name.getToken(), type, param);
    }

    private void emitJSDocLine(String name, String type, String param) {
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(JSGoogDocEmitterTokens.STAR);
        this.write(ASEmitterTokens.ATSIGN);
        this.write(name);
        if (type != "") {
            this.write(ASEmitterTokens.SPACE);
            this.writeBlockOpen();
            this.write(type);
            this.writeBlockClose();
        }
        if (param != "") {
            this.write(ASEmitterTokens.SPACE);
            this.write(param);
        }
        this.writeNewline();
    }

    protected boolean containsThisReference(IASNode node) {
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            IASNode child = node.getChild(i);
            if (child.getChildCount() > 0) {
                return this.containsThisReference(child);
            }
            if (!SemanticUtils.isThisKeyword((IASNode)child)) continue;
            return true;
        }
        return false;
    }

    protected String convertASTypeToJS(String name, String pname) {
        return JSGoogDocEmitter.convertASTypeToJSType(name, pname);
    }

    public static String convertASTypeToJSType(String name, String pname) {
        String result = "";
        if (name.equals("")) {
            result = ASEmitterTokens.ANY_TYPE.getToken();
        } else if (name.equals("Class")) {
            result = "Object";
        } else if (name.equals("Boolean") || name.equals("String") || name.equals("Number")) {
            result = name.toLowerCase();
        } else if (name.equals("int") || name.equals("uint")) {
            result = "Number".toLowerCase();
        }
        boolean isBuiltinFunction = name.matches("Vector\\.<.*>");
        if (isBuiltinFunction) {
            String elementType = name.substring(8, name.length() - 1);
            elementType = JSGoogDocEmitter.convertASTypeToJSType(elementType, pname);
            name = "Array.<" + elementType + ">";
        } else {
            IASGlobalFunctionConstants.BuiltinType[] builtinTypes;
            for (IASGlobalFunctionConstants.BuiltinType builtinType : builtinTypes = IASGlobalFunctionConstants.BuiltinType.values()) {
                if (!name.equalsIgnoreCase(builtinType.getName())) continue;
                isBuiltinFunction = true;
                break;
            }
        }
        if (result == "") {
            result = pname != "" && !isBuiltinFunction && name.indexOf(".") < 0 ? pname + ASEmitterTokens.MEMBER_ACCESS.getToken() + name : name;
        }
        return result;
    }

    protected IClassDefinition resolveClassDefinition(IFunctionNode node) {
        IScopedNode scope = node.getContainingScope();
        if (scope instanceof IMXMLDocumentNode) {
            return ((IMXMLDocumentNode)scope).getClassDefinition();
        }
        IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        if (cnode == null) {
            return null;
        }
        return cnode.getDefinition();
    }

    protected String formatQualifiedName(String name) {
        return name;
    }

    public static String now() {
        String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(cal.getTime());
    }

    public static String getTimeStampString() {
        return "CROSS-COMPILED BY MXMLJSC (329449.1) ON " + JSGoogDocEmitter.now() + "\n";
    }
}

