/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv.routeinfo;

import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.namesrv.NamesrvConfig;
import org.apache.rocketmq.common.protocol.header.namesrv.UnRegisterBrokerRequestHeader;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.namesrv.routeinfo.RouteInfoManager;

public class BatchUnregistrationService
extends ServiceThread {
    private final RouteInfoManager routeInfoManager;
    private BlockingQueue<UnRegisterBrokerRequestHeader> unregistrationQueue;
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqNamesrv");

    public BatchUnregistrationService(RouteInfoManager routeInfoManager, NamesrvConfig namesrvConfig) {
        this.routeInfoManager = routeInfoManager;
        this.unregistrationQueue = new LinkedBlockingQueue<UnRegisterBrokerRequestHeader>(namesrvConfig.getUnRegisterBrokerQueueCapacity());
    }

    public boolean submit(UnRegisterBrokerRequestHeader unRegisterRequest) {
        return this.unregistrationQueue.offer(unRegisterRequest);
    }

    public String getServiceName() {
        return BatchUnregistrationService.class.getName();
    }

    public void run() {
        while (!this.isStopped()) {
            try {
                UnRegisterBrokerRequestHeader request = this.unregistrationQueue.take();
                HashSet<UnRegisterBrokerRequestHeader> unregistrationRequests = new HashSet<UnRegisterBrokerRequestHeader>();
                this.unregistrationQueue.drainTo(unregistrationRequests);
                unregistrationRequests.add(request);
                this.routeInfoManager.unRegisterBroker(unregistrationRequests);
            }
            catch (Throwable e) {
                log.error("Handle unregister broker request failed", e);
            }
        }
    }

    int queueLength() {
        return this.unregistrationQueue.size();
    }
}

