/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.trace.hook;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import org.apache.rocketmq.client.hook.EndTransactionContext;
import org.apache.rocketmq.client.hook.EndTransactionHook;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageType;

public class EndTransactionOpenTracingHookImpl
implements EndTransactionHook {
    private Tracer tracer;

    public EndTransactionOpenTracingHookImpl(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public String hookName() {
        return "EndTransactionOpenTracingHook";
    }

    @Override
    public void endTransaction(EndTransactionContext context) {
        if (context == null) {
            return;
        }
        Message msg = context.getMessage();
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan("EndTransaction").withTag((Tag)Tags.SPAN_KIND, (Object)"producer");
        SpanContext spanContext = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new TextMapAdapter(msg.getProperties()));
        if (spanContext != null) {
            spanBuilder.asChildOf(spanContext);
        }
        Span span = spanBuilder.start();
        span.setTag((Tag)Tags.PEER_SERVICE, (Object)"rocketmq");
        span.setTag((Tag)Tags.MESSAGE_BUS_DESTINATION, (Object)msg.getTopic());
        span.setTag("rocketmq.tags", msg.getTags());
        span.setTag("rocketmq.keys", msg.getKeys());
        span.setTag("rocketmq.store_host", context.getBrokerAddr());
        span.setTag("rocketmq.mgs_id", context.getMsgId());
        span.setTag("rocketmq.mgs_type", MessageType.Trans_msg_Commit.name());
        span.setTag("rocketmq.transaction_id", context.getTransactionId());
        span.setTag("rocketmq.transaction_state", context.getTransactionState().name());
        span.setTag("rocketmq.is_from_transaction_check", context.isFromTransactionCheck());
        span.finish();
    }
}

