/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.process;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;

public class RangerUgSyncRESTClient
extends RangerRESTClient {
    private String AUTH_KERBEROS = "kerberos";

    public RangerUgSyncRESTClient(String policyMgrBaseUrls, String ugKeyStoreFile, String ugKeyStoreFilepwd, String ugKeyStoreType, String ugTrustStoreFile, String ugTrustStoreFilepwd, String ugTrustStoreType, String authenticationType, String principal, String keytab, String polMgrUsername, String polMgrPassword) {
        super(policyMgrBaseUrls, "", UserGroupSyncConfig.getInstance().getConfig());
        if (authenticationType == null || !this.AUTH_KERBEROS.equalsIgnoreCase(authenticationType) || !SecureClientLogin.isKerberosCredentialExists((String)principal, (String)keytab)) {
            this.setBasicAuthInfo(polMgrUsername, polMgrPassword);
        }
        if (this.isSSL()) {
            this.setKeyStoreType(ugKeyStoreType);
            this.setTrustStoreType(ugTrustStoreType);
            KeyManager[] kmList = this.getKeyManagers(ugKeyStoreFile, ugKeyStoreFilepwd);
            TrustManager[] tmList = this.getTrustManagers(ugTrustStoreFile, ugTrustStoreFilepwd);
            SSLContext sslContext = this.getSSLContext(kmList, tmList);
            DefaultClientConfig config = new DefaultClientConfig();
            config.getClasses().add(JacksonJsonProvider.class);
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return session.getPeerHost().equals(urlHostName);
                }
            };
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hv, sslContext));
            this.setClient(Client.create((ClientConfig)config));
            if (StringUtils.isNotEmpty((String)this.getUsername()) && StringUtils.isNotEmpty((String)this.getPassword())) {
                this.getClient().addFilter((ClientFilter)new HTTPBasicAuthFilter(this.getUsername(), this.getPassword()));
            }
        }
        UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
        super.setMaxRetryAttempts(config.getPolicyMgrMaxRetryAttempts());
        super.setRetryIntervalMs(config.getPolicyMgrRetryIntervalMs());
    }
}

