/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.trino.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.trino.client.TrinoClient;
import org.apache.ranger.services.trino.client.TrinoConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrinoResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(TrinoResourceManager.class);
    private static final String CATALOG = "catalog";
    private static final String SCHEMA = "schema";
    private static final String TABLE = "table";
    private static final String COLUMN = "column";

    private TrinoResourceManager() {
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TrinoResourceManager.connectionTest() ServiceName: " + serviceName + " Configs: " + configs);
        }
        try {
            ret = TrinoClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== TrinoResourceManager.connectionTest() Error: " + e);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TrinoResourceManager.connectionTest() Result : " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTrinoResources(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List resultList;
        block30: {
            String userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            List catalogList = null;
            List schemaList = null;
            List tableList = null;
            List columnList = null;
            String catalogName = null;
            String schemaName = null;
            String tableName = null;
            String columnName = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== TrinoResourceMgr.getTrinoResources() UserInput: \"" + userInput + "\" resource : " + resource + " resourceMap: " + resourceMap);
            }
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    catalogList = (List)resourceMap.get(CATALOG);
                    schemaList = (List)resourceMap.get(SCHEMA);
                    tableList = (List)resourceMap.get(TABLE);
                    columnList = (List)resourceMap.get(COLUMN);
                }
                switch (resource.trim().toLowerCase()) {
                    case "catalog": {
                        catalogName = userInput;
                        break;
                    }
                    case "schema": {
                        schemaName = userInput;
                    }
                    case "table": {
                        tableName = userInput;
                        break;
                    }
                    case "column": {
                        columnName = userInput;
                        break;
                    }
                }
            }
            if (serviceName != null && userInput != null) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("==> TrinoResourceManager.getTrinoResources() UserInput: \"" + userInput + "\" configs: " + configs + " catalogList: " + catalogList + " tableList: " + tableList + " columnList: " + columnList);
                    }
                    final TrinoClient trinoClient = new TrinoConnectionManager().getTrinoConnection(serviceName, serviceType, configs);
                    Callable<List<String>> callableObj = null;
                    final List finalCatalogList = catalogList;
                    final List finalSchemaList = schemaList;
                    final List finalTableList = tableList;
                    final List finalColumnList = columnList;
                    if (trinoClient == null) break block30;
                    if (catalogName != null && !catalogName.isEmpty()) {
                        final String finalCatalogName = catalogName;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() throws Exception {
                                return trinoClient.getCatalogList(finalCatalogName, finalCatalogList);
                            }
                        };
                    } else if (schemaName != null && !schemaName.isEmpty()) {
                        final String finalSchemaName = schemaName;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() throws Exception {
                                return trinoClient.getSchemaList(finalSchemaName, finalCatalogList, finalSchemaList);
                            }
                        };
                    } else if (tableName != null && !tableName.isEmpty()) {
                        final String finalTableName = tableName;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() throws Exception {
                                return trinoClient.getTableList(finalTableName, finalCatalogList, finalSchemaList, finalTableList);
                            }
                        };
                    } else if (columnName != null && !columnName.isEmpty()) {
                        final String finalColumnName = columnName = columnName + "*";
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() throws Exception {
                                return trinoClient.getColumnList(finalColumnName, finalCatalogList, finalSchemaList, finalTableList, finalColumnList);
                            }
                        };
                    }
                    if (callableObj != null) {
                        TrinoClient trinoClient2 = trinoClient;
                        synchronized (trinoClient2) {
                            resultList = (List)TimedEventUtil.timedTask((Callable)callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                            break block30;
                        }
                    }
                    LOG.error("Could not initiate a TrinoClient timedTask");
                }
                catch (Exception e) {
                    LOG.error("Unable to get Trino resource", (Throwable)e);
                    throw e;
                }
            }
        }
        return resultList;
    }
}

