/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AlgorithmParameters;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.hadoop.crypto.key.JavaKeyStoreProvider;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.RangerKeyStoreProvider;
import org.apache.log4j.Logger;
import org.apache.ranger.entity.XXRangerKeyStore;
import org.apache.ranger.kms.dao.DaoManager;
import org.apache.ranger.kms.dao.RangerKMSDao;

public class RangerKeyStore
extends KeyStoreSpi {
    static final Logger logger = Logger.getLogger(RangerKeyStore.class);
    private static final String KEY_NAME_VALIDATION = "[a-z,A-Z,0-9](?!.*--)(?!.*__)(?!.*-_)(?!.*_-)[\\w\\-\\_]*";
    private static final Pattern pattern = Pattern.compile("[a-z,A-Z,0-9](?!.*--)(?!.*__)(?!.*-_)(?!.*_-)[\\w\\-\\_]*");
    private DaoManager daoManager;
    private Map<String, Object> keyEntries = new ConcurrentHashMap<String, Object>();
    private Map<String, Object> deltaEntries = new ConcurrentHashMap<String, Object>();
    private final String SECRET_KEY_HASH_WORD = "Apache Ranger";
    private static final String METADATA_FIELDNAME = "metadata";
    private static final int NUMBER_OF_BITS_PER_BYTE = 8;

    RangerKeyStore() {
    }

    public RangerKeyStore(DaoManager daoManager) {
        this.daoManager = daoManager;
    }

    String convertAlias(String alias) {
        return alias.toLowerCase();
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStore.engineGetKey()");
        }
        Key key = null;
        Object entry = this.keyEntries.get(this.convertAlias(alias));
        if (!(entry instanceof SecretKeyEntry)) {
            return null;
        }
        try {
            key = this.unsealKey(((SecretKeyEntry)entry).sealedKey, password);
        }
        catch (Exception e) {
            logger.error((Object)"==> RangerKeyStore.engineGetKey() error: ", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerKeyStore.engineGetKey()");
        }
        return key;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        Object entry = this.keyEntries.get(this.convertAlias(alias));
        Date date = null;
        if (entry != null) {
            KeyEntry keyEntry = (KeyEntry)entry;
            if (keyEntry.date != null) {
                date = new Date(keyEntry.date.getTime());
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyEntry(String alias, Key key, char[] password, String cipher, int bitLength, String description, int version, String attributes) throws KeyStoreException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStore.addKeyEntry()");
            logger.debug((Object)("Adding entry for alias:" + alias));
        }
        SecretKeyEntry entry = new SecretKeyEntry();
        Map<String, Object> map = this.deltaEntries;
        synchronized (map) {
            try {
                entry.date = new Date();
                entry.sealedKey = this.sealKey(key, password);
                entry.cipher_field = cipher;
                entry.bit_length = bitLength;
                entry.description = description;
                entry.version = version;
                entry.attributes = attributes;
                this.deltaEntries.put(this.convertAlias(alias), entry);
            }
            catch (Exception e) {
                logger.error((Object)"==> RangerKeyStore.addKeyEntry() error: ", (Throwable)e);
                throw new KeyStoreException(e.getMessage());
            }
        }
        map = this.keyEntries;
        synchronized (map) {
            try {
                this.keyEntries.put(this.convertAlias(alias), entry);
            }
            catch (Exception e) {
                logger.error((Object)"==> RangerKeyStore.addKeyEntry() error: ", (Throwable)e);
                throw new KeyStoreException(e.getMessage());
            }
        }
    }

    private SealedObject sealKey(Key key, char[] password) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStore.sealKey()");
        }
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndTripleDES");
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
        pbeKeySpec.clearPassword();
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        PBEParameterSpec pbeSpec = new PBEParameterSpec(salt, 20);
        Cipher cipher = Cipher.getInstance("PBEWithMD5AndTripleDES");
        cipher.init(1, (Key)secretKey, pbeSpec);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerKeyStore.sealKey()");
        }
        return new RangerSealedObject(key, cipher);
    }

    private Key unsealKey(SealedObject sealedKey, char[] password) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStore.unsealKey()");
        }
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndTripleDES");
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
        pbeKeySpec.clearPassword();
        AlgorithmParameters algorithmParameters = null;
        algorithmParameters = sealedKey instanceof RangerSealedObject ? ((RangerSealedObject)sealedKey).getParameters() : new RangerSealedObject(sealedKey).getParameters();
        Cipher cipher = Cipher.getInstance("PBEWithMD5AndTripleDES");
        cipher.init(2, (Key)secretKey, algorithmParameters);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerKeyStore.unsealKey()");
        }
        return (Key)sealedKey.getObject(cipher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Map<String, Object> map = this.keyEntries;
        synchronized (map) {
            this.dbOperationDelete(this.convertAlias(alias));
            this.keyEntries.remove(this.convertAlias(alias));
        }
        map = this.deltaEntries;
        synchronized (map) {
            this.deltaEntries.remove(this.convertAlias(alias));
        }
    }

    private void dbOperationDelete(String alias) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("==> RangerKeyStore.dbOperationDelete(" + alias + ")"));
        }
        try {
            if (this.daoManager != null) {
                RangerKMSDao rangerKMSDao = new RangerKMSDao(this.daoManager);
                rangerKMSDao.deleteByAlias(alias);
            }
        }
        catch (Exception e) {
            logger.error((Object)"==> RangerKeyStore.dbOperationDelete() error : ", (Throwable)e);
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.keyEntries.keySet());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.keyEntries.containsKey(this.convertAlias(alias));
    }

    @Override
    public int engineSize() {
        return this.keyEntries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStore.engineStore()");
        }
        Map<String, Object> map = this.deltaEntries;
        synchronized (map) {
            if (password == null) {
                throw new IllegalArgumentException("Ranger Master Key can't be null");
            }
            MessageDigest md = this.getKeyedMessageDigest(password);
            byte[] digest = md.digest();
            for (Map.Entry<String, Object> entry : this.deltaEntries.entrySet()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(new DigestOutputStream(baos, md));
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(dos);
                    oos.writeObject(((SecretKeyEntry)entry.getValue()).sealedKey);
                    dos.write(digest);
                    dos.flush();
                    Long creationDate = ((SecretKeyEntry)entry.getValue()).date.getTime();
                    SecretKeyEntry secretKey = (SecretKeyEntry)entry.getValue();
                    XXRangerKeyStore xxRangerKeyStore = this.mapObjectToEntity(entry.getKey(), creationDate, baos.toByteArray(), secretKey.cipher_field, secretKey.bit_length, secretKey.description, secretKey.version, secretKey.attributes);
                    this.dbOperationStore(xxRangerKeyStore);
                }
                finally {
                    if (oos != null) {
                        oos.close();
                        continue;
                    }
                    dos.close();
                }
            }
            this.clearDeltaEntires();
        }
    }

    private XXRangerKeyStore mapObjectToEntity(String alias, Long creationDate, byte[] byteArray, String cipher_field, int bit_length, String description, int version, String attributes) {
        XXRangerKeyStore xxRangerKeyStore = new XXRangerKeyStore();
        xxRangerKeyStore.setAlias(alias);
        xxRangerKeyStore.setCreatedDate(creationDate);
        xxRangerKeyStore.setEncoded(DatatypeConverter.printBase64Binary((byte[])byteArray));
        xxRangerKeyStore.setCipher(cipher_field);
        xxRangerKeyStore.setBitLength(bit_length);
        xxRangerKeyStore.setDescription(description);
        xxRangerKeyStore.setVersion(version);
        xxRangerKeyStore.setAttributes(attributes);
        return xxRangerKeyStore;
    }

    private void dbOperationStore(XXRangerKeyStore rangerKeyStore) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStore.dbOperationStore()");
        }
        try {
            if (this.daoManager != null) {
                RangerKMSDao rangerKMSDao = new RangerKMSDao(this.daoManager);
                XXRangerKeyStore xxRangerKeyStore = rangerKMSDao.findByAlias(rangerKeyStore.getAlias());
                boolean keyStoreExists = true;
                if (xxRangerKeyStore == null) {
                    xxRangerKeyStore = new XXRangerKeyStore();
                    keyStoreExists = false;
                }
                xxRangerKeyStore = this.mapToEntityBean(rangerKeyStore, xxRangerKeyStore);
                if (keyStoreExists) {
                    xxRangerKeyStore = rangerKMSDao.update(xxRangerKeyStore);
                } else {
                    XXRangerKeyStore xXRangerKeyStore = rangerKMSDao.create(xxRangerKeyStore);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"==> RangerKeyStore.dbOperationStore() error : ", (Throwable)e);
        }
    }

    private XXRangerKeyStore mapToEntityBean(XXRangerKeyStore rangerKMSKeyStore, XXRangerKeyStore xxRangerKeyStore) {
        xxRangerKeyStore.setAlias(rangerKMSKeyStore.getAlias());
        xxRangerKeyStore.setCreatedDate(rangerKMSKeyStore.getCreatedDate());
        xxRangerKeyStore.setEncoded(rangerKMSKeyStore.getEncoded());
        xxRangerKeyStore.setCipher(rangerKMSKeyStore.getCipher());
        xxRangerKeyStore.setBitLength(rangerKMSKeyStore.getBitLength());
        xxRangerKeyStore.setDescription(rangerKMSKeyStore.getDescription());
        xxRangerKeyStore.setVersion(rangerKMSKeyStore.getVersion());
        xxRangerKeyStore.setAttributes(rangerKMSKeyStore.getAttributes());
        return xxRangerKeyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStore.engineLoad()");
        }
        Map<String, Object> map = this.keyEntries;
        synchronized (map) {
            List<XXRangerKeyStore> rangerKeyDetails = this.dbOperationLoad();
            MessageDigest md = null;
            if (rangerKeyDetails == null || rangerKeyDetails.size() < 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RangerKeyStore might be null or key is not present in the database.");
                }
                return;
            }
            this.keyEntries.clear();
            if (password != null) {
                md = this.getKeyedMessageDigest(password);
            }
            byte[] computed = new byte[]{};
            if (md != null) {
                computed = md.digest();
            }
            for (XXRangerKeyStore rangerKey : rangerKeyDetails) {
                String encoded = rangerKey.getEncoded();
                byte[] data = DatatypeConverter.parseBase64Binary((String)encoded);
                if (data != null && data.length > 0) {
                    stream = new ByteArrayInputStream(data);
                } else {
                    logger.error((Object)("No Key found for alias " + rangerKey.getAlias()));
                }
                if (computed != null) {
                    int counter = 0;
                    for (int i = computed.length - 1; i >= 0; --i) {
                        if (computed[i] != data[data.length - (1 + counter)]) {
                            UnrecoverableKeyException t = new UnrecoverableKeyException("Password verification failed");
                            logger.error((Object)"Keystore was tampered with, or password was incorrect.", (Throwable)t);
                            throw (IOException)new IOException("Keystore was tampered with, or password was incorrect").initCause(t);
                        }
                        ++counter;
                    }
                }
                DataInputStream dis = password != null ? new DataInputStream(new DigestInputStream(stream, md)) : new DataInputStream(stream);
                ObjectInputStream ois = null;
                try {
                    SecretKeyEntry entry = new SecretKeyEntry();
                    String alias = rangerKey.getAlias();
                    entry.date = new Date(rangerKey.getCreatedDate());
                    entry.cipher_field = rangerKey.getCipher();
                    entry.bit_length = rangerKey.getBitLength();
                    entry.description = rangerKey.getDescription();
                    entry.version = rangerKey.getVersion();
                    entry.attributes = rangerKey.getAttributes();
                    try {
                        ois = new ObjectInputStream(dis);
                        entry.sealedKey = (SealedObject)ois.readObject();
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new IOException(cnfe.getMessage());
                    }
                    this.keyEntries.put(alias, entry);
                }
                finally {
                    if (ois != null) {
                        ois.close();
                        continue;
                    }
                    dis.close();
                }
            }
        }
    }

    private List<XXRangerKeyStore> dbOperationLoad() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStore.dbOperationLoad()");
        }
        try {
            if (this.daoManager != null) {
                RangerKMSDao rangerKMSDao = new RangerKMSDao(this.daoManager);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"<== RangerKeyStore.dbOperationLoad()");
                }
                return rangerKMSDao.getAllKeys();
            }
        }
        catch (Exception e) {
            logger.error((Object)"==> RangerKeyStore.dbOperationLoad() error:", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerKeyStore.dbOperationLoad()");
        }
        return null;
    }

    private MessageDigest getKeyedMessageDigest(char[] aKeyPassword) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int i;
        MessageDigest md = MessageDigest.getInstance("SHA");
        byte[] keyPasswordBytes = new byte[aKeyPassword.length * 2];
        int j = 0;
        for (i = 0; i < aKeyPassword.length; ++i) {
            keyPasswordBytes[j++] = (byte)(aKeyPassword[i] >> 8);
            keyPasswordBytes[j++] = (byte)aKeyPassword[i];
        }
        md.update(keyPasswordBytes);
        for (i = 0; i < keyPasswordBytes.length; ++i) {
            keyPasswordBytes[i] = 0;
        }
        md.update("Apache Ranger".getBytes("UTF8"));
        return md;
    }

    @Override
    public void engineSetKeyEntry(String arg0, byte[] arg1, Certificate[] arg2) throws KeyStoreException {
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return null;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return false;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoadKeyStoreFile(InputStream stream, char[] storePass, char[] keyPass, char[] masterKey, String fileFormat) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStoreProvider.engineLoadKeyStoreFile()");
        }
        Map<String, Object> map = this.deltaEntries;
        synchronized (map) {
            try {
                KeyStore ks = KeyStore.getInstance(fileFormat);
                ks.load(stream, storePass);
                this.deltaEntries.clear();
                Enumeration<String> name = ks.aliases();
                while (name.hasMoreElements()) {
                    Constructor<Object> constructor;
                    SecretKeyEntry entry = new SecretKeyEntry();
                    String alias = name.nextElement();
                    Key k = ks.getKey(alias, keyPass);
                    if (k instanceof JavaKeyStoreProvider.KeyMetadata) {
                        JavaKeyStoreProvider.KeyMetadata keyMetadata = (JavaKeyStoreProvider.KeyMetadata)k;
                        Field f = JavaKeyStoreProvider.KeyMetadata.class.getDeclaredField(METADATA_FIELDNAME);
                        f.setAccessible(true);
                        KeyProvider.Metadata metadata = (KeyProvider.Metadata)f.get(keyMetadata);
                        entry.bit_length = metadata.getBitLength();
                        entry.cipher_field = metadata.getAlgorithm();
                        constructor = RangerKeyStoreProvider.KeyMetadata.class.getDeclaredConstructor(KeyProvider.Metadata.class);
                        constructor.setAccessible(true);
                        RangerKeyStoreProvider.KeyMetadata nk = (RangerKeyStoreProvider.KeyMetadata)constructor.newInstance(metadata);
                        k = nk;
                    } else {
                        entry.bit_length = k.getEncoded().length * 8;
                        entry.cipher_field = k.getAlgorithm();
                    }
                    String keyName = alias.split("@")[0];
                    this.validateKeyName(keyName);
                    entry.attributes = "{\"key.acl.name\":\"" + keyName + "\"}";
                    Class<?> c = null;
                    Object o = null;
                    try {
                        c = Class.forName("com.sun.crypto.provider.KeyProtector");
                        constructor = c.getDeclaredConstructor(char[].class);
                        constructor.setAccessible(true);
                        o = constructor.newInstance(new Object[]{masterKey});
                        Method m = c.getDeclaredMethod("seal", Key.class);
                        m.setAccessible(true);
                        entry.sealedKey = (SealedObject)m.invoke(o, k);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        logger.error((Object)e.getMessage());
                        throw new IOException(e.getMessage());
                    }
                    entry.date = ks.getCreationDate(alias);
                    entry.version = alias.split("@").length == 2 ? Integer.parseInt(alias.split("@")[1]) : 0;
                    entry.description = k.getFormat() + " - " + ks.getType();
                    this.deltaEntries.put(alias, entry);
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Unable to load keystore file ", t);
                throw new IOException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoadToKeyStoreFile(OutputStream stream, char[] storePass, char[] keyPass, char[] masterKey, String fileFormat) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStoreProvider.engineLoadToKeyStoreFile()");
        }
        Map<String, Object> map = this.keyEntries;
        synchronized (map) {
            try {
                KeyStore ks = KeyStore.getInstance(fileFormat);
                if (ks != null) {
                    ks.load(null, storePass);
                    String alias = null;
                    this.engineLoad(null, masterKey);
                    Enumeration<String> e = this.engineAliases();
                    while (e.hasMoreElements()) {
                        alias = e.nextElement();
                        Key key = this.engineGetKey(alias, masterKey);
                        ks.setKeyEntry(alias, key, keyPass, null);
                    }
                    ks.store(stream, storePass);
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Unable to load keystore file ", t);
                throw new IOException(t);
            }
        }
    }

    private void validateKeyName(String name) {
        Matcher matcher = pattern.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Key Name : " + name + ", should start with alpha/numeric letters and can have special characters - (hypen) or _ (underscore)");
        }
    }

    public void clearDeltaEntires() {
        this.deltaEntries.clear();
    }

    private static class RangerSealedObject
    extends SealedObject {
        private static final long serialVersionUID = -7551578543434362070L;

        protected RangerSealedObject(SealedObject so) {
            super(so);
        }

        protected RangerSealedObject(Serializable object, Cipher cipher) throws IllegalBlockSizeException, IOException {
            super(object, cipher);
        }

        public AlgorithmParameters getParameters() throws NoSuchAlgorithmException, IOException {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("PBEWithMD5AndTripleDES");
            algorithmParameters.init(this.encodedParams);
            return algorithmParameters;
        }
    }

    private static final class SecretKeyEntry {
        Date date = new Date();
        SealedObject sealedKey;
        String cipher_field;
        int bit_length;
        String description;
        String attributes;
        int version;

        private SecretKeyEntry() {
        }
    }

    private static class KeyEntry {
        Date date = new Date();

        private KeyEntry() {
        }
    }
}

