/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.atlas.authorizer;

import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasRelationshipAccessRequest;
import org.apache.atlas.authorize.AtlasSearchResultScrubRequest;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.authorize.AtlasTypesDefFilterRequest;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAtlasAuthorizer
implements AtlasAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAtlasAuthorizer.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();
    private static final String RANGER_PLUGIN_TYPE = "atlas";
    private static final String RANGER_ATLAS_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.atlas.authorizer.RangerAtlasAuthorizer";
    private AtlasAuthorizer rangerAtlasAuthorizerImpl = null;
    private RangerPluginClassLoader rangerPluginClassLoader = null;

    public RangerAtlasAuthorizer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAtlasAuthorizer.RangerAtlasAuthorizer()");
        }
        this.init0();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAtlasAuthorizer.RangerAtlasAuthorizer()");
        }
    }

    private void init0() {
        LOG.info("Initializing RangerAtlasPlugin");
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_ATLAS_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.rangerAtlasAuthorizerImpl = (AtlasAuthorizer)cls.newInstance();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerAtlasPlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAtlasPlugin.init()");
        }
    }

    public void init() {
        if (isDebugEnabled) {
            LOG.debug("==> RangerAtlasAuthorizer.init");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerAtlasAuthorizerImpl.init();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (isDebugEnabled) {
            LOG.debug("<== RangerAtlasAuthorizer.init()");
        }
    }

    public void cleanUp() {
        if (isDebugEnabled) {
            LOG.debug("cleanUp <===");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerAtlasAuthorizerImpl.cleanUp();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public boolean isAccessAllowed(AtlasAdminAccessRequest request) throws AtlasAuthorizationException {
        boolean ret;
        if (isDebugEnabled) {
            LOG.debug("==> isAccessAllowed(AtlasAdminAccessRequest)");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.rangerAtlasAuthorizerImpl.isAccessAllowed(request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (isDebugEnabled) {
            LOG.debug("<== isAccessAllowed(AtlasAdminAccessRequest): " + ret);
        }
        return ret;
    }

    public boolean isAccessAllowed(AtlasEntityAccessRequest request) throws AtlasAuthorizationException {
        boolean ret;
        if (isDebugEnabled) {
            LOG.debug("==> isAccessAllowed(AtlasEntityAccessRequest)");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.rangerAtlasAuthorizerImpl.isAccessAllowed(request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (isDebugEnabled) {
            LOG.debug("<== isAccessAllowed(AtlasEntityAccessRequest): " + ret);
        }
        return ret;
    }

    public boolean isAccessAllowed(AtlasTypeAccessRequest request) throws AtlasAuthorizationException {
        boolean ret;
        if (isDebugEnabled) {
            LOG.debug("==> isAccessAllowed(AtlasTypeAccessRequest)");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.rangerAtlasAuthorizerImpl.isAccessAllowed(request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (isDebugEnabled) {
            LOG.debug("<== isAccessAllowed(AtlasTypeAccessRequest): " + ret);
        }
        return ret;
    }

    public boolean isAccessAllowed(AtlasRelationshipAccessRequest request) throws AtlasAuthorizationException {
        boolean ret;
        if (isDebugEnabled) {
            LOG.debug("==> isAccessAllowed(AtlasTypeAccessRequest)");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.rangerAtlasAuthorizerImpl.isAccessAllowed(request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (isDebugEnabled) {
            LOG.debug("<== isAccessAllowed(AtlasTypeAccessRequest): " + ret);
        }
        return ret;
    }

    public void scrubSearchResults(AtlasSearchResultScrubRequest request) throws AtlasAuthorizationException {
        if (isDebugEnabled) {
            LOG.debug("==> scrubSearchResults(" + request + ")");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerAtlasAuthorizerImpl.scrubSearchResults(request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (isDebugEnabled) {
            LOG.debug("<== scrubSearchResults(): " + request);
        }
    }

    public void filterTypesDef(AtlasTypesDefFilterRequest request) throws AtlasAuthorizationException {
        if (isDebugEnabled) {
            LOG.debug("==> filterTypesDef(" + request + ")");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerAtlasAuthorizerImpl.filterTypesDef(request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (isDebugEnabled) {
            LOG.debug("<== filterTypesDef(): " + request);
        }
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

