/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestUtils {
    public static String dumpThreads() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(true, true);
        StringBuilder dump = new StringBuilder();
        dump.append(String.format("%n", new Object[0]));
        for (ThreadInfo threadInfo : threadInfos) {
            dump.append(threadInfo);
        }
        long[] deadLocks = threadMXBean.findDeadlockedThreads();
        if (deadLocks != null && deadLocks.length > 0) {
            ThreadInfo[] deadlockedThreads = threadMXBean.getThreadInfo(deadLocks);
            dump.append(String.format("%n", new Object[0]));
            dump.append("Deadlock is detected!");
            dump.append(String.format("%n", new Object[0]));
            for (ThreadInfo threadInfo : deadlockedThreads) {
                dump.append(threadInfo);
            }
        }
        return dump.toString();
    }

    public static Class<?> getTestClass(ExtensionContext extensionContext) {
        return (Class)extensionContext.getTestClass().orElseThrow(() -> new RuntimeException("Failed to resolve test class"));
    }

    public static Method getTestMethod(ExtensionContext extensionContext) {
        return (Method)extensionContext.getTestMethod().orElseThrow(() -> new RuntimeException("Failed to resolve test method"));
    }
}

