/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils;

import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SystemPropertySetter
implements AfterAllCallback {
    private final Map<String, String> _storedProperties = new HashMap<String, String>();

    public synchronized void afterEach() {
        this.afterAll(null);
    }

    public synchronized void afterAll(ExtensionContext ctx) {
        this._storedProperties.forEach(this::setProperty);
    }

    public synchronized void setSystemProperty(String name, String value) {
        this._storedProperties.putIfAbsent(name, System.getProperty(name));
        this.setProperty(name, value);
    }

    private void setProperty(String name, String value) {
        if (value == null) {
            System.clearProperty(name);
        } else {
            System.setProperty(name, value);
        }
    }
}

