/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils.tls;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.qpid.test.utils.tls.KeyStoreEntry;

public class TlsResourceHelper {
    private static final byte[] LINE_SEPARATOR = new byte[]{13, 10};
    private static final String BEGIN_X_509_CRL = "-----BEGIN X509 CRL-----";
    private static final String END_X_509_CRL = "-----END X509 CRL-----";
    private static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static final int PEM_LINE_LENGTH = 76;

    public static KeyStore createKeyStore(String keyStoreType, char[] secret, KeyStoreEntry ... entries) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore ks = TlsResourceHelper.createKeyStoreOfType(keyStoreType);
        for (KeyStoreEntry e : entries) {
            e.addEntryToKeyStore(ks, secret);
        }
        return ks;
    }

    public static String createKeyStoreAsDataUrl(String keyStoreType, char[] secret, KeyStoreEntry ... entries) throws Exception {
        KeyStore ks = TlsResourceHelper.createKeyStore(keyStoreType, secret, entries);
        return TlsResourceHelper.toDataUrl(ks, secret);
    }

    public static KeyStore createKeyStoreOfType(String keyStoreType) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        ks.load(null, null);
        return ks;
    }

    public static void saveKeyStoreIntoFile(KeyStore ks, char[] secret, File storeFile) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        try (FileOutputStream fos = new FileOutputStream(storeFile);){
            ks.store(fos, secret);
        }
    }

    public static String toDataUrl(KeyStore ks, char[] secret) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String result;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ks.store(os, secret);
            result = TlsResourceHelper.getDataUrlForBytes(os.toByteArray());
        }
        return result;
    }

    public static String getDataUrlForBytes(byte[] bytes) {
        return "data:;base64," + Base64.getEncoder().encodeToString(bytes);
    }

    public static SecretKey createAESSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256);
        return keyGen.generateKey();
    }

    public static void saveBytesAsPem(byte[] bytes, String header, String footer, OutputStream out) throws IOException {
        out.write(header.getBytes(StandardCharsets.UTF_8));
        out.write(LINE_SEPARATOR);
        out.write(Base64.getMimeEncoder(76, LINE_SEPARATOR).encode(bytes));
        out.write(LINE_SEPARATOR);
        out.write(footer.getBytes(StandardCharsets.UTF_8));
        out.write(LINE_SEPARATOR);
    }

    public static void saveCertificateAsPem(OutputStream os, X509Certificate ... certificate) throws IOException, CertificateEncodingException {
        for (X509Certificate b : certificate) {
            TlsResourceHelper.saveBytesAsPem(b.getEncoded(), BEGIN_CERTIFICATE, END_CERTIFICATE, os);
        }
    }

    public static void savePrivateKeyAsPem(OutputStream os, PrivateKey key) throws IOException {
        TlsResourceHelper.saveBytesAsPem(key.getEncoded(), BEGIN_PRIVATE_KEY, END_PRIVATE_KEY, os);
    }

    public static void saveCrlAsPem(OutputStream os, X509CRL crl) throws CRLException, IOException {
        TlsResourceHelper.saveBytesAsPem(crl.getEncoded(), BEGIN_X_509_CRL, END_X_509_CRL, os);
    }

    public static String toPEM(Certificate pub) throws CertificateEncodingException {
        return TlsResourceHelper.toPEM(pub.getEncoded(), BEGIN_CERTIFICATE, END_CERTIFICATE);
    }

    public static String toPEM(PrivateKey key) {
        return TlsResourceHelper.toPEM(key.getEncoded(), BEGIN_PRIVATE_KEY, END_PRIVATE_KEY);
    }

    private static String toPEM(byte[] bytes, String header, String footer) {
        StringBuilder pem = new StringBuilder();
        pem.append(header).append(new String(LINE_SEPARATOR, StandardCharsets.UTF_8));
        pem.append(Base64.getMimeEncoder(76, LINE_SEPARATOR).encodeToString(bytes));
        pem.append(new String(LINE_SEPARATOR, StandardCharsets.UTF_8)).append(footer).append(new String(LINE_SEPARATOR, StandardCharsets.UTF_8));
        return pem.toString();
    }
}

