/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils.tls;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.qpid.test.utils.tls.KeyStoreEntry;

public final class PrivateKeyEntry
implements KeyStoreEntry {
    private final String _alias;
    private final PrivateKey _privateKey;
    private final Certificate[] _certificates;

    public PrivateKeyEntry(String alias, PrivateKey privateKey, Certificate ... certificate) {
        this._alias = alias;
        this._privateKey = privateKey;
        this._certificates = certificate;
    }

    String getAlias() {
        return this._alias;
    }

    @Override
    public void addEntryToKeyStore(KeyStore keyStore, char[] secret) throws KeyStoreException {
        keyStore.setKeyEntry(this.getAlias(), this.getPrivateKey(), secret, this.getCertificates());
    }

    PrivateKey getPrivateKey() {
        return this._privateKey;
    }

    Certificate[] getCertificates() {
        return this._certificates;
    }
}

